<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Models\Balance;
use Illuminate\Validation\Rule;

class BillingController extends Controller
{
    public function index(Request $request)
    {

        if ($request->ajax()) {
            $date1 = $request->date1;
            $date2 = $request->date2;
            $status = $request->status;
            if ($date1 && $date2) {
                $date1 = $date1 . ' 00:00:00';
                $date2 = $date2 . ' 23:59:59';
                $data = Balance::whereBetween('created_at', [$date1, $date2]);
                if ($status && $status != 'ALL') {
                    $data = $data->where('status', $status);
                }
            } else {
                $data = Balance::query();
            }

            return Datatables::of($data)
                ->editColumn('created_at', function ($row) {
                    return $row->created_at->format('d-m-Y H:i:s');
                })
                ->addIndexColumn()
                ->addColumn('action', function ($row) {
                    $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Edit" class="btn btn-primary btn-xs editData"><i class="fa fa-edit"></i></a>';
                    $btn = $btn . ' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Delete" class="btn btn-danger btn-xs deleteData"><i class="fa fa-trash"></i></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('admin.billing');
    }

    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'name' => [
                'required',
                Rule::unique('discounts')->ignore($request->id),
            ],
            'code' => [
                'required',
                Rule::unique('discounts')->ignore($request->id),
            ],
            'quota' => 'required',
            'amount' => 'required',
        ]);

        Balance::updateOrCreate(
            [
                'id' => $request->id
            ],
            [
                'name' => $request->name,
                'code' => $request->code,
                'quota' => str_replace(',', '', $request->quota),
                'amount' => str_replace(',', '', $request->amount),
            ]
        );
        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function show($id): JsonResponse
    {
        $data = Balance::find($id);
        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => $data,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function destroy(Request $request): JsonResponse
    {
        $request->validate([
            'id' => 'required|integer|exists:balances,id',
        ]);
        $updated = Balance::find($request->id)?->delete();
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $updated ? 200 : 404,
                'message' => $updated ? 'OK' : 'Record not found or already inactive',
            ]
        ], $updated ? 200 : 404);
    }
}
