<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Models\Balance;
use App\Models\User;
use App\Models\VpsServer;
use App\Models\VpsSubscription;
use Carbon\Carbon;
use Illuminate\Validation\Rule;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $subs_count = VpsSubscription::count();
        $date1 =  Carbon::now('Asia/Jakarta')->format('Y-m-01') . ' 00:00:00';
        $date2 =  Carbon::now('Asia/Jakarta')->format('Y-m-d') . ' 23:59:59';
        $total_amount = number_format(Balance::whereBetween('created_at', [$date1, $date2])->where('status', 'PAID')->sum('amount_topup'), 2, '.', ',');
        $user_count = User::count();
        $vps_count = VpsServer::count();

        return view('admin.index', compact('subs_count', 'total_amount', 'user_count', 'vps_count'));
    }

    public function show(Request $request)
    {
        $subs_count = VpsSubscription::count();
        $date1 = !empty($request->date1) ? $request->date1 : Carbon::now('Asia/Jakarta')->format('Y-m-01');
        $date2 = !empty($request->date2) ? $request->date1 : Carbon::now('Asia/Jakarta')->format('Y-m-d');
        $date1 =  $date1 . ' 00:00:00';
        $date2 =  $date2 . ' 23:59:59';
        $total_amount = number_format(Balance::whereBetween('created_at', [$date1, $date2])->where('status', 'PAID')->sum('amount'), 2, '.', ',');
        $user_count = User::count();
        $vps_count = VpsServer::count();

        return response()->json([
            'response' => compact('subs_count', 'total_amount', 'user_count', 'vps_count'),
            'metadata' => [
                'code' => 200,
                'message' => 'OK',
            ]
        ], 200);
    }
}
