<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Models\Discount;
use Illuminate\Validation\Rule;

class DiscountController extends Controller
{
    public function index(Request $request)
    {

        if ($request->ajax()) {

            $data = Discount::query();

            return Datatables::of($data)
                ->editColumn('expires_at', function ($row) {
                    return $row->expires_at->format('d-m-Y H:i:s');
                })
                ->addIndexColumn()
                ->addColumn('action', function ($row) {
                    $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Edit" class="btn btn-primary btn-xs editData"><i class="fa fa-edit"></i></a>';
                    $btn = $btn . ' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Delete" class="btn btn-danger btn-xs deleteData"><i class="fa fa-trash"></i></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('admin.discount');
    }

    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'name' => [
                'required',
                Rule::unique('discounts')->ignore($request->id),
            ],
            'code' => [
                'required',
                Rule::unique('discounts')->ignore($request->id),
            ],
            'quota' => 'required',
            'amount' => 'required',
            'amount_min' => 'required',
            'expires_at' => 'required',
        ]);

        Discount::updateOrCreate(
            [
                'id' => $request->id
            ],
            [
                'name' => $request->name,
                'code' => $request->code,
                'quota' => str_replace(',', '', $request->quota),
                'amount' => str_replace(',', '', $request->amount),
                'amount_min' => str_replace(',', '', $request->amount_min),
                'expires_at' => $request->expires_at . ' ' . $request->expires_at_time . ':00',
            ]
        );
        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function show($id): JsonResponse
    {
        $data = Discount::find($id);
        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => $data,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function destroy(Request $request): JsonResponse
    {
        $request->validate([
            'id' => 'required|integer|exists:discounts,id',
        ]);
        $updated = Discount::find($request->id)?->delete();
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $updated ? 200 : 404,
                'message' => $updated ? 'OK' : 'Record not found or already inactive',
            ]
        ], $updated ? 200 : 404);
    }
}
