<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vps_details', function (Blueprint $table) {
            $table->id();
            $table->integer('vps_id')->index();
            $table->integer('vps_proxies_id')->index();
            $table->integer('vps_category_id')->index();
            $table->decimal('price', 15, 2)->default(0);
            $table->decimal('price_hour', 15, 2)->default(0);
            $table->integer('quota')->default(0);
            $table->integer('quota_used')->default(0);
            $table->integer('max_session')->default(2);
            $table->integer('data_limit')->default(0);
            $table->string('data_limit_reset_strategy')->default('no_reset');
            $table->boolean('is_pay')->default(true);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vps_details');
    }
};
