<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vps_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->index();
            $table->integer('vps_details_id')->index();
            $table->string('username');
            $table->string('password');
            $table->decimal('balance', 15, 2)->default(0);
            $table->text('config')->nullable();
            $table->boolean('suspend')->default(false);
            $table->softDeletes();
            $table->timestamp('pay_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vps_subscriptions');
    }
};
