<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email');
            $table->string('phone');
            $table->text('address1');
            $table->text('address2');
            $table->string('city');
            $table->string('postal_code');
            $table->string('region');
            $table->decimal('min_amount', 15, 2)->default(0);
            $table->decimal('min_amount_ip', 15, 2)->default(0);
            $table->integer('payment_expired')->default(180);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
