@extends('layouts.admin')
@section('css')
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Discount</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Discount</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="card">
                <div class="card-body">
                    <div class="d-grid gap-2 d-md-flex mb-3">
                        <a class="btn btn-success btn-sm" href="javascript:void(0)" id="createData"> <i
                                class="fa fa-plus"></i> Create</a>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover text-nowrap data-table w-100">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Name</th>
                                    <th>Code</th>
                                    <th>Quota</th>
                                    <th>Used</th>
                                    <th>Amount Disc</th>
                                    <th>Amount Min</th>
                                    <th>Expired</th>
                                    <th width="100px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <div class="modal fade" id="formModal1" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="formModalHeading1"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="dataForm1" name="dataForm1" class="form-horizontal">
                        <input type="hidden" name="id" id="id">
                        @csrf
                        <div class="alert alert-danger print-error-msg" style="display:none">
                            <ul></ul>
                        </div>

                        <div class="form-group">
                            <label for="name" class="col-sm-12 control-label">Name</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="name" name="name"
                                    placeholder="Enter Name">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="code" class="col-sm-12 control-label">Code</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="code" name="code"
                                    placeholder="Enter Code">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="quota" class="col-sm-12 control-label">Quota</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control quota" id="quota" name="quota"
                                    placeholder="Enter Quota">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="amount" class="col-sm-12 control-label">Amount Discount</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control price" id="amount" name="amount"
                                    placeholder="Enter Amount Discount">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="amount_min" class="col-sm-12 control-label">Amount Min Topup</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control price" id="amount_min" name="amount_min"
                                    placeholder="Enter Amount Min Topup">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="expires_at" class="col-sm-12 control-label">Expired</label>
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="col-6">
                                        <input type="date" class="form-control" id="expires_at" name="expires_at"
                                            placeholder="Enter Expired" value="{{ date('Y-m-d') }}">
                                    </div>
                                    <div class="col-6">
                                        <input type="time" class="form-control" id="expires_at_time"
                                            name="expires_at_time" placeholder="Enter Expired"
                                            value="{{ date('H:i') }}">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-offset-2 col-sm-10">
                            <button type="submit" class="btn btn-success mt-2" id="saveBtn">Submit</button>
                            <button type="button" class="btn btn-danger mt-2" id="cancelBtn" data-dismiss="modal"><i
                                    class="fa fa-cancel"></i>
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(function() {
            var table = $('.data-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.discount') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'code',
                        name: 'code'
                    },
                    {
                        data: 'quota',
                        name: 'quota',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    },
                    {
                        data: 'quota_used',
                        name: 'quota_used',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    },
                    {
                        data: 'amount',
                        name: 'amount',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2
                            }).format(data);
                        }
                    },
                    {
                        data: 'amount_min',
                        name: 'amount_min',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2
                            }).format(data);
                        }
                    },
                    {
                        data: 'expires_at',
                        name: 'expires_at'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

            $('#createData').click(function() {
                $('#id').val('');
                $('#dataForm1').trigger("reset");
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                $('#formModalHeading1').html("<i class='fa fa-plus'></i> Create Data");
                $('#formModal1').modal('show');
            });

            $('body').on('click', '.editData', function() {
                var id = $(this).data('id');
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                $.get("{{ route('admin.discount-show', '') }}/" + id, function(data) {
                    $('#formModalHeading1').html(
                        "<i class='fa-regular fa-pen-to-square'></i> Edit Data");
                    $('#formModal1').modal('show');
                    console.log(data);
                    $('#id').val(data.response.id);
                    $('#name').val(data.response.name);
                    $('#code').val(data.response.code);
                    $('#quota').val(formatQuota(data.response.quota));
                    $('#amount').val(formatAmount(data.response.amount));
                    $('#amount_min').val(formatAmount(data.response.amount_min));
                    console.log(data.response.expires_at.substring(0, 10));
                    console.log(data.response.expires_at.substring(11, 16));
                    $('#expires_at').val(data.response.expires_at.substring(0, 10));
                    $('#expires_at_time').val(data.response.expires_at.substring(11, 16));
                })
            });

            $('#dataForm1').submit(function(e) {
                e.preventDefault();
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                let formData = new FormData(this);
                $('#saveBtn').html('Sending...');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.discount-store') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: (response) => {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').trigger("reset");
                        $('#formModal1').modal('hide');
                        table.draw();
                    },
                    error: function(response) {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').find(".print-error-msg").find("ul").html('');
                        $('#dataForm1').find(".print-error-msg").css('display', 'block');
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#dataForm1').find(".print-error-msg").find("ul")
                                .append('<li>' + value + '</li>');
                        });
                    }
                });

            });

            $('body').on('click', '.deleteData', function() {
                var id = $(this).data("id");
                var isConfirmed = confirm("Are You sure want to delete?");

                if (isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "{{ route('admin.discount-delete', '') }}/" + id,
                        success: function(data) {
                            table.draw();
                        },
                        error: function(data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

        });
    </script>
@endsection
