@extends('layouts.admin')
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Dashboard</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="col-sm-12">
                <div class="row">
                    <div class="col-12 col-sm-2">
                        <div class="form-group">
                            <label for="filterDate1">Start</label>
                            <input type="date" class="form-control" id="filterDate1" value="{{ date('Y-m-01') }}">
                        </div>
                    </div>
                    <div class="col-12 col-sm-2">
                        <div class="form-group">
                            <label for="filterDate2">End</label>
                            <input type="date" class="form-control" id="filterDate2" value="{{ date('Y-m-d') }}">
                        </div>
                    </div>
                    <div class="col-12 col-sm-2">
                        <div class="form-group">
                            <label for="filterData">&nbsp;</label>
                            <a class="btn btn-success form-control" href="javascript:void(0)" id="filterData">
                                <i class="fa fa-search"></i> Filter</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-3 col-12">
                    <!-- small box -->
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h5 id="subs_count">{{ $subs_count }}</h5>
                            <p>Subcriptions</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-bag"></i>
                        </div>
                        <a href="{{ route('admin.subscription') }}" class="small-box-footer">More info <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-12">
                    <!-- small box -->
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h5 id="total_amount">{{ $total_amount }}</h5>
                            <p>Income</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-stats-bars"></i>
                        </div>
                        <a href="{{ route('admin.billing') }}" class="small-box-footer">More info <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-12">
                    <!-- small box -->
                    <div class="small-box bg-secondary">
                        <div class="inner">
                            <h5 id="user_count">{{ $user_count }}</h5>
                            <p>Total Members</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-person"></i>
                        </div>
                        <a href="{{ route('admin.user') }}" class="small-box-footer">More info <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-12">
                    <!-- small box -->
                    <div class="small-box bg-purple">
                        <div class="inner">
                            <h5 id="vps_count">{{ $vps_count }}</h5>
                            <p>VPS Server</p>
                        </div>
                        <div class="icon">
                            <i class="ion ion-pie-graph"></i>
                        </div>
                        <a href="{{ route('admin.vps-server.index') }}" class="small-box-footer">More info <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
@endsection
@section('js')
    <script>
        $(function() {
            $('#filterData').click(function() {
                let baseUrl = "{{ route('admin.show', ['date1' => 'DATE1', 'date2' => 'DATE2']) }}";
                baseUrl = baseUrl.replace('DATE1', $('#filterDate1').val())
                    .replace('DATE2', $('#filterDate2').val());
                $.get(baseUrl,
                    function(data) {
                        $('#subs_count').html(data.response.subs_count);
                        $('#total_amount').html(formatQuota(data.response.total_amount));
                        $('#user_count').html(data.response.user_count);
                        $('#vps_count').html(data.response.vps_count);
                    });
            });
        });
    </script>
@endsection
