@extends('layouts.admin')
@section('css')
    <style>
        a {
            color: #000000;
        }
    </style>
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Subscription</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Subscription</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <!-- Default box -->
            <div class="card">
                <div class="card-body">
                    <div class="mb-3">
                        <div class="row">
                            <div class="col-12 col-sm-2">
                                <div class="form-group">
                                    <label for="filter_vps_id" class="col-sm-12 control-label">VPS Server</label>
                                    <div class="col-sm-12">
                                        <select class="form-control select2" id="filter_vps_id"
                                            placeholder="Select VPS"></select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-2">
                                <div class="form-group">
                                    <label for="filter_vps_proxies_id" class="col-sm-12 control-label">Proxies</label>
                                    <div class="col-sm-12">
                                        <select class="form-control select2" id="filter_vps_proxies_id"
                                            placeholder="Select Proxies">
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-1">
                                <div class="form-group">
                                    <label for="filterData">&nbsp;</label>
                                    <a class="btn btn-success form-control" href="javascript:void(0)" id="filterData"> <i
                                            class="fa fa-search"></i> Filter</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover text-nowrap data-table w-100">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Email</th>
                                    <th>Name</th>
                                    <th>Proxies</th>
                                    <th>Username</th>
                                    <th>Balance</th>
                                    <th>Pay At</th>
                                    <th width="100px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->

        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <div class="modal fade" id="formModal1" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="formModalHeading1"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="dataForm1" name="dataForm1" class="form-horizontal">
                        <input type="hidden" name="id" id="id">
                        @csrf
                        <div class="alert alert-danger print-error-msg" style="display:none">
                            <ul></ul>
                        </div>
                        <div class="form-group">
                            <label for="user_id" class="col-sm-12 control-label">User Email</label>
                            <div class="col-sm-12">
                                <select class="form-control select2" id="user_id" name="user_id"
                                    placeholder="Select User"></select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="vps_details_id" class="col-sm-12 control-label">Server</label>
                            <div class="col-sm-12">
                                <select class="form-control select2" id="vps_details_id" name="vps_details_id"
                                    placeholder="Select Server"></select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="username" class="col-sm-12 control-label">Username</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="username" name="username"
                                    placeholder="Enter username">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="password" class="col-sm-12 control-label">Password</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="password" name="password"
                                    placeholder="Enter Password">
                            </div>
                        </div>
                        <div class="col-sm-offset-2 col-sm-10">
                            <button type="submit" class="btn btn-success mt-2" id="saveBtn">Submit
                            </button>
                            <button type="button" class="btn btn-danger mt-2" id="cancelBtn" data-dismiss="modal"><i
                                    class="fa fa-cancel"></i>
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(function() {
            $('#user_id').select2({
                placeholder: 'Select User Email',
                ajax: {
                    url: "{{ route('admin.user-select') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term,
                            page: params.page || 1
                        };
                    },
                    processResults: function(data, params) {
                        params.page = params.page || 1;
                        return {
                            results: data.data,
                            pagination: {
                                more: data.next_page_url !== null
                            }
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0,
            });
            $('#vps_details_id').select2({
                placeholder: 'Select VPS Server',
                ajax: {
                    url: "{{ route('admin.vps-detail-select') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term,
                            page: params.page || 1
                        };
                    },
                    processResults: function(data, params) {
                        params.page = params.page || 1;
                        return {
                            results: data.data,
                            pagination: {
                                more: data.next_page_url !== null
                            }
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0,
            });
            $('#filter_vps_id').select2({
                placeholder: 'Select VPS',
                ajax: {
                    url: "{{ route('admin.vps-server-select') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term,
                            page: params.page || 1
                        };
                    },
                    processResults: function(data, params) {
                        params.page = params.page || 1;
                        let allOption = {
                            id: 'all',
                            text: 'ALL'
                        };
                        let results = [allOption].concat(data.data);
                        return {
                            results: results,
                            pagination: {
                                more: data.next_page_url !== null
                            }
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0,
            });
            $('#filter_vps_proxies_id').select2({
                placeholder: 'Select Proxies',
                ajax: {
                    url: "{{ route('admin.vps-proxies-select') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term,
                            page: params.page || 1
                        };
                    },
                    processResults: function(data, params) {
                        params.page = params.page || 1;
                        let allOption = {
                            id: 'all',
                            text: 'ALL'
                        };
                        let results = [allOption].concat(data.data);
                        return {
                            results: results,
                            pagination: {
                                more: data.next_page_url !== null
                            }
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0,
            });
            $("#filter_vps_id").append(new Option('ALL', 'all')).change();
            $("#filter_vps_proxies_id").append(new Option('ALL', 'all')).change();
            var table = $('.data-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.subscription') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'email',
                        name: 'users.email'
                    },
                    {
                        data: 'vps_name',
                        name: 'vps.name'
                    },
                    {
                        data: 'vps_proxies_name',
                        name: 'vps_proxies.name'
                    },
                    {
                        data: 'username',
                        name: 'username'
                    },
                    {
                        data: 'balance',
                        name: 'balance'
                    },
                    {
                        data: 'pay_at',
                        name: 'pay_at'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

            $('body').on('click', '.editData', function() {
                var id = $(this).data('id');
                $.get("{{ route('admin.subscription-show', '') }}/" + id, function(data) {
                    $('#formModalHeading1').html(
                        "<i class='fa-regular fa-pen-to-square'></i> Edit Data");
                    $('#formModal1').modal('show');
                    $('#id').val(data.response.id);
                    $('#name').val(data.response.name);
                    $('#email').val(data.response.email);
                    $('#phone').val(data.response.phone);
                    $('#amount').val(formatAmount(data.response.amount));
                    $('#role').val(data.response.role).change();
                })
            });

            $('#dataForm1').submit(function(e) {
                e.preventDefault();
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                let formData = new FormData(this);
                $('#saveBtn').html('Sending...');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.subscription-store') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: (response) => {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').trigger("reset");
                        $('#formModal1').modal('hide');
                        table.draw();
                    },
                    error: function(response) {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').find(".print-error-msg").find("ul").html('');
                        $('#dataForm1').find(".print-error-msg").css('display', 'block');
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#dataForm1').find(".print-error-msg").find("ul")
                                .append('<li>' + value + '</li>');
                        });
                    }
                });

            });

            $('body').on('click', '.deleteData', function() {
                var id = $(this).data("id");
                var isConfirmed = confirm("Are You sure want to delete?");
                if (isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "{{ route('admin.subscription-delete', '') }}/" + id,
                        success: function(data) {
                            table.draw();
                        },
                        error: function(data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

        });
    </script>
@endsection
