@extends('layouts.admin')
@section('css')
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>VPS Country</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">VPS Country</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="card">
                <div class="card-body">
                    <div class="d-grid gap-2 d-md-flex mb-3">
                        <a class="btn btn-success btn-sm" href="javascript:void(0)" id="createData"> <i
                                class="fa fa-plus"></i> Create</a>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover text-nowrap data-table w-100">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Code</th>
                                    <th>Name</th>
                                    <th>Seq</th>
                                    <th width="100px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <div class="modal fade" id="formModal1" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="formModalHeading1"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="dataForm1" name="dataForm1" class="form-horizontal">
                        <input type="hidden" name="id" id="id">
                        @csrf
                        <div class="alert alert-danger print-error-msg" style="display:none">
                            <ul></ul>
                        </div>

                        <div class="form-group">
                            <label for="code" class="col-sm-2 control-label">Code</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="code" name="code"
                                    placeholder="Enter code">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="name" class="col-sm-2 control-label">Name</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="name" name="name"
                                    placeholder="Enter Name">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="seq" class="col-sm-2 control-label">Seq</label>
                            <div class="col-sm-12">
                                <input type="number" class="form-control" id="seq" name="seq"
                                    placeholder="Enter Seq" value="0">
                            </div>
                        </div>

                        <div class="col-sm-offset-2 col-sm-10">
                            <button type="submit" class="btn btn-success mt-2" id="saveBtn">Submit
                            </button>
                            <button type="button" class="btn btn-danger mt-2" id="cancelBtn" data-dismiss="modal"><i
                                    class="fa fa-cancel"></i>
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(function() {
            var table = $('.data-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.vps-country') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'code',
                        name: 'code'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'seq',
                        name: 'seq'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                ordering: true,
                order: [
                    [3, 'asc']
                ],
            });

            $('#createData').click(function() {
                $('#id').val('');
                $('#dataForm1').trigger("reset");
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                $('#formModalHeading1').html("<i class='fa fa-plus'></i> Create Data");
                $('#formModal1').modal('show');
            });

            $('body').on('click', '.editData', function() {
                var id = $(this).data('id');
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                $.get("{{ route('admin.vps-country-show', '') }}/" + id, function(data) {
                    data = data.response;
                    $('#formModal1').modal('show');
                    $('#formModalHeading1').html(
                        "<i class='fa-regular fa-pen-to-square'></i> Edit Data");
                    $('#formModal1').modal('show');
                    $('#id').val(data.id);
                    $('#code').val(data.code);
                    $('#name').val(data.name);
                    $('#seq').val(data.seq);
                })
            });

            $('#dataForm1').submit(function(e) {
                e.preventDefault();
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                let formData = new FormData(this);
                $('#saveBtn').html('Sending...');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.vps-country-store') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: (response) => {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').trigger("reset");
                        $('#formModal1').modal('hide');
                        table.draw();
                    },
                    error: function(response) {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').find(".print-error-msg").find("ul").html('');
                        $('#dataForm1').find(".print-error-msg").css('display', 'block');
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#dataForm1').find(".print-error-msg").find("ul")
                                .append('<li>' + value + '</li>');
                        });
                    }
                });

            });
        });
    </script>
@endsection
