@extends('layouts.admin')
@section('css')
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>VPS Proxies</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">VPS Proxies</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="card">
                <div class="card-body">
                    <div class="d-grid gap-2 d-md-flex mb-3">
                        <div class="">
                            <select class="form-control" id="selectTable">
                                <option value="0">All</option>
                                <option value="1">Trash</option>
                            </select>
                        </div>
                        <div class="m-3">
                        </div>
                        <div>
                            <a class="btn btn-success form-control" href="javascript:void(0)" id="createData"> <i
                                    class="fa fa-plus"></i>
                                Create</a>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover text-nowrap data-table w-100">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Name</th>
                                    <th>Seq</th>
                                    <th width="100px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <div class="modal fade" id="formModal1" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="formModalHeading1"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="dataForm1" name="dataForm1" class="form-horizontal">
                        <input type="hidden" name="id" id="id">
                        @csrf
                        <div class="alert alert-danger print-error-msg" style="display:none">
                            <ul></ul>
                        </div>

                        <div class="form-group">
                            <label for="name" class="col-sm-2 control-label">Name</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="name" name="name"
                                    placeholder="Enter Name">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="seq" class="col-sm-2 control-label">Seq</label>
                            <div class="col-sm-12">
                                <input type="number" class="form-control" id="seq" name="seq"
                                    placeholder="Enter seq" value="0">
                            </div>
                        </div>

                        <div class="col-sm-offset-2 col-sm-10">
                            <button type="submit" class="btn btn-success mt-2" id="saveBtn">Submit</button>
                            <button type="button" class="btn btn-danger mt-2" id="cancelBtn" data-dismiss="modal"><i
                                    class="fa fa-cancel"></i>
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(function() {
            var table = $('.data-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('admin.vps-proxies') }}",
                    data: function(d) {
                        d.showDeleted = $('#selectTable').val();
                    }
                },
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'seq',
                        name: 'seq'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ],
                ordering: true,
                order: [
                    [2, 'asc']
                ],
            });

            $('#selectTable').on('change', function() {
                table.ajax.reload();
            });

            $('#createData').click(function() {
                $('#id').val('');
                $('#dataForm1').trigger("reset");
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                $('#formModalHeading1').html("<i class='fa fa-plus'></i> Create Data");
                $('#formModal1').modal('show');
            });

            $('body').on('click', '.editData', function() {
                var id = $(this).data('id');
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                $.get("{{ route('admin.vps-proxies-show', '') }}/" + id, function(data) {
                    data = data.response;
                    $('#formModal1').modal('show');
                    $('#formModalHeading1').html(
                        "<i class='fa-regular fa-pen-to-square'></i> Edit Data");
                    $('#formModal1').modal('show');
                    $('#id').val(data.id);
                    $('#seq').val(data.seq);
                    $('#name').val(data.name);
                })
            });

            $('body').on('click', '.restoreData', function() {
                let id = $(this).data('id');
                let name = $(this).data('name');
                Swal.fire({
                    title: `Are you sure?`,
                    text: `Data ${name} is restored`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#e3342f',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Yes, Restore'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            type: "DELETE",
                            url: "{{ route('admin.vps-proxies-restore', '') }}/" + id,
                            success: function(response) {
                                table.draw();
                                Swal.fire('Success', response.metadata.message,
                                    'success');
                            },
                            error: function() {
                                Swal.fire('Failed',
                                    'Failed restore data.',
                                    'error');
                            }
                        });
                    }
                });
            });

            $('body').on('click', '.deleteData', function() {
                let id = $(this).data('id');
                let name = $(this).data('name');
                Swal.fire({
                    title: `Are you sure?`,
                    text: `Data ${name} is deleted`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#e3342f',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Yes, delete'
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            type: "DELETE",
                            url: "{{ route('admin.vps-proxies-destroy', '') }}/" + id,
                            success: function(response) {
                                table.draw();
                                Swal.fire('Berhasil', response.metadata.message,
                                    'success');
                            },
                            error: function() {
                                Swal.fire('Gagal',
                                    'Failed delete data.',
                                    'error');
                            }
                        });
                    }
                });
            });

            $('#dataForm1').submit(function(e) {
                e.preventDefault();
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                let formData = new FormData(this);
                $('#saveBtn').html('Sending...');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.vps-proxies-store') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: (response) => {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').trigger("reset");
                        $('#formModal1').modal('hide');
                        table.draw();
                    },
                    error: function(response) {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').find(".print-error-msg").find("ul").html('');
                        $('#dataForm1').find(".print-error-msg").css('display', 'block');
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#dataForm1').find(".print-error-msg").find("ul")
                                .append('<li>' + value + '</li>');
                        });
                    }
                });

            });
        });
    </script>
@endsection
