@extends('layouts.auth')
@section('content')

    <body class="hold-transition register-page">
        <div class="register-box">
            <div class="card">
                <div class="card-header text-center border-0">
                    <p class="mb-0 pb-0">
                        <img src="{{ asset('dist/img/logoapp.png') }}" alt="LingVPN Logo" class="img-circle img-fluid"
                            width="50" height="50" style="opacity: .8">
                    </p>
                    <a href="#" class="h5">LingVPN</a>
                </div>
                <div class="card-body">
                    <p class="login-box-msg">Register a new membership</p>
                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            <h5><i class="icon fas fa-ban"></i> Alert!</h5>
                            @foreach ($errors->all() as $error)
                                {{ $error }}<br />
                            @endforeach
                        </div>
                    @endif
                    <form method="POST" action="{{ route('register') }}">
                        @csrf
                        <div class="input-group mb-3">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-user"></span>
                                </div>
                            </div>
                            <input type="text" class="form-control" placeholder="Full name" name="name" id="name"
                                value="{{ old('name', session('google_data.name', '')) }}" required>
                        </div>
                        <div class="input-group mb-3">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-envelope"></span>
                                </div>
                            </div>
                            <input type="email" class="form-control" placeholder="Email" name="email" id="email"
                                value="{{ old('email', session('google_data.email', '')) }}" required>
                        </div>
                        <div class="input-group mb-3">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-lock"></span>
                                </div>
                            </div>
                            <input type="password" class="form-control" placeholder="Password" name="password"
                                id="password" value="{{ old('password') }}" required>
                        </div>
                        <div class="input-group mb-3">
                            <div class="input-group-append">
                                <div class="input-group-text">
                                    <span class="fas fa-lock"></span>
                                </div>
                            </div>
                            <input type="password" class="form-control" placeholder="Retype password"
                                name="password_confirmation" id="password_confirmation"
                                value="{{ old('password_confirmation') }}" required>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="icheck-primary">
                                    <input type="checkbox" id="agreeTerms" name="terms" value="agree" required>
                                    <label for="agreeTerms">
                                        I agree to the <a href="{{ route('term-of-service') }}">terms</a>
                                    </label>
                                </div>
                            </div>
                            <!-- /.col -->
                            <div class="col-12 my-3">
                                <div class="form-group">
                                    {!! NoCaptcha::display() !!}
                                    @error('g-recaptcha-response')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!-- /.col -->
                            <div class="col-12">
                                <button type="submit" class="btn btn-success btn-block">Register</button>
                            </div>
                            <!-- /.col -->
                        </div>
                    </form>

                    <div class="social-auth-links text-center">
                        <a href="{{ route('login.google') }}" class="btn btn-block btn-default">
                            <i class="fab fa-google mr-2 text-danger"></i> Register using Google
                        </a>
                    </div>

                    <a href="{{ route('login') }}" class="text-center text-black">I already have a membership</a>
                </div>
                <!-- /.form-box -->
            </div><!-- /.card -->
        </div>
        <!-- /.register-box -->
    @endsection
