@extends('layouts.member')
@section('css')
    <style>
        a {
            color: #000000;
        }
    </style>
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Information</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Information</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <!-- Default box -->
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="callout callout-primary">
                                <h4 class="main-title d-flex align-items-center"><ion-icon class="me-1 md hydrated"
                                        name="information" role="img" aria-label="information"></ion-icon> Readme!</h4>
                                <p class="main-description">Visit <a href="{{ route('term-of-service') }}">FAQ</a> to
                                    understand about
                                    LingVPN.</p>
                            </div>
                            @foreach ($information as $item)
                                <div class="callout callout-{{ $item->category }}">
                                    <h4 class="main-title d-flex align-items-center text-{{ $item->category }}"><ion-icon
                                            class="me-1 md hydrated" name="{{ $item->category }}-outline" role="img"
                                            aria-label="{{ $item->category }} outline"></ion-icon>
                                        {{ $item->name }}</h4>
                                    <p class="main-description">{{ $item->description }}</p>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
@endsection
@section('js')
    <script>
        $(function() {
            //
        });
    </script>
@endsection
