@extends('layouts.website')
@section('css')
@endsection
@section('content')
    <div class="container pt-5">
        <div class="row justify-content-center align-items-center">
            <div class="col-12 col-sm-6 col-md-4">
                <div class="card shadow">
                    <!-- form start -->
                    <form action="{{ route('tools-host-to-ip-resolve') }}" method="POST">
                        @csrf
                        <div class="card-body">
                            @error('failed')
                                <div class="alert alert-danger">
                                    {{ $message }}
                                </div>
                            @enderror
                            @if (session('ip'))
                                <div class="alert alert-success">
                                    IP Address: <strong>{{ session('ip') }}</strong>
                                </div>
                            @endif
                            <h3 class="text-center">Host to IP</h3>
                            <div class="form-group">
                                <input type="text" class="form-control" name="hostname" id="hostname"
                                    placeholder="Enter Hostname">
                                <small class="form-text text-muted">Please input valid hostname example: google.com</small>
                            </div>
                            <div class="form-group my-3">
                                {!! NoCaptcha::display() !!}
                                @error('g-recaptcha-response')
                                    <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            <button type="submit" class="btn btn-dark w-100">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
@endsection
