<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\WebsiteController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\TripayController;
use App\Http\Controllers\Admin\BillingController;
use App\Http\Controllers\Admin\InvoiceController;
use App\Http\Controllers\Admin\MarzbanController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\DiscountController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\VpsDetailController;
use App\Http\Controllers\Admin\VpsServerController;
use App\Http\Controllers\Admin\VpsCountryController;
use App\Http\Controllers\Admin\VpsProxiesController;
use App\Http\Controllers\Admin\InformationController;
use App\Http\Controllers\Admin\VpsCategoryController;
use App\Http\Controllers\Admin\SubscriptionController;
use App\Http\Controllers\Member\MemberAccountController;
use App\Http\Controllers\Member\MemberBalanceController;
use App\Http\Controllers\Member\MemberInvoiceController;
use App\Http\Controllers\Member\MemberProductController;
use App\Http\Controllers\Member\MemberInformationController;

// Route::get('/', function () {
//     return view('layouts.website');
// })->name('index');
Route::get('/', [WebsiteController::class, 'index'])->name('index');
Route::get('/pricing', [WebsiteController::class, 'pricing'])->name('pricing');
Route::get('/tools/data-center', [WebsiteController::class, 'dataCenter'])->name('tools-data-center');
Route::get('/tools/host-to-ip', [WebsiteController::class, 'hostToIp'])->name('tools-host-to-ip');
Route::post('/tools/host-to-ip-resolve', [WebsiteController::class, 'hostToIpResolve'])->name('tools-host-to-ip-resolve');
Route::get('/blog', [WebsiteController::class, 'blog'])->name('blog');
Route::get('/sitemap', [WebsiteController::class, 'sitemap'])->name('sitemap');
Route::get('/term-of-service', [WebsiteController::class, 'termOfService'])->name('term-of-service');
Route::get('/privacy-policy', [WebsiteController::class, 'privacyPolicy'])->name('privacy-policy');
Route::get('/disclaimer', [WebsiteController::class, 'disclaimer'])->name('disclaimer');

Route::get('/login', [AuthController::class, 'loginForm'])->name('login');
Route::get('login-google', [AuthController::class, 'loginGoogle'])->name('login.google');
Route::get('login-google-callback', [AuthController::class, 'loginGoogleCallback'])->name('login.google.callback');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register', [AuthController::class, 'registerForm'])->name('register');
Route::post('/register', [AuthController::class, 'register']);
Route::get('/forgot-password', function () {
    return view('auth.forgot_password');
})->name('forgot-password');
Route::get('/recover-password', function () {
    return view('auth.recover_password');
})->name('recover-password');

Route::middleware(['auth'])->group(function () {
    //global
    Route::get('/logout', [AuthController::class, 'logout'])->name('logout');
    Route::get('/payment-channel', [TripayController::class, 'paymentChannel'])->name('payment.channel');
    Route::get('/payment-discount/{discount_code}', [MemberBalanceController::class, 'discount'])->name('payment.discount');
    //admin
    Route::middleware(['role:admin'])->prefix('admin')->name('admin.')->group(function () {
        Route::get('/', [DashboardController::class, 'index'])->name('index');
        Route::get('/show/{date1}/{date2}', [DashboardController::class, 'show'])->name('show');
        Route::get('/billing', [BillingController::class, 'index'])->name('billing');
        Route::get('/billing-show/{id}', [BillingController::class, 'show'])->name('billing-show');
        Route::post('/billing-store', [BillingController::class, 'store'])->name('billing-store');
        Route::delete('/billing-delete/{id}', [BillingController::class, 'destroy'])->name('billing-delete');
        Route::get('/invoice', [InvoiceController::class, 'index'])->name('invoice');
        Route::get('/user', [UserController::class, 'index'])->name('user');
        Route::get('/user-show/{id}', [UserController::class, 'show'])->name('user-show');
        Route::post('/user-store', [UserController::class, 'store'])->name('user-store');
        Route::delete('/user-delete/{id}', [UserController::class, 'destroy'])->name('user-delete');
        Route::get('/subscription', [SubscriptionController::class, 'index'])->name('subscription');
        Route::get('/subscription-show/{id}', [SubscriptionController::class, 'show'])->name('subscription-show');
        Route::post('/subscription-store', [SubscriptionController::class, 'store'])->name('subscription-store');
        Route::delete('/subscription-delete/{id}', [SubscriptionController::class, 'destroy'])->name('subscription-delete');
        Route::get('/discount', [DiscountController::class, 'index'])->name('discount');
        Route::get('/discount-show/{id}', [DiscountController::class, 'show'])->name('discount-show');
        Route::post('/discount-store', [DiscountController::class, 'store'])->name('discount-store');
        Route::delete('/discount-delete/{id}', [DiscountController::class, 'destroy'])->name('discount-delete');
        Route::get('/information', [InformationController::class, 'index'])->name('information');
        Route::get('/information-show/{id}', [InformationController::class, 'show'])->name('information-show');
        Route::post('/information-store', [InformationController::class, 'store'])->name('information-store');
        Route::delete('/information-delete/{id}', [InformationController::class, 'destroy'])->name('information-delete');
        Route::resource('/vps-server', VpsServerController::class);
        Route::get('/vps-category', [VpsCategoryController::class, 'index'])->name('vps-category');
        Route::get('/vps-category-show/{id}', [VpsCategoryController::class, 'show'])->name('vps-category-show');
        Route::post('/vps-category-store', [VpsCategoryController::class, 'store'])->name('vps-category-store');
        Route::delete('/vps-category-delete/{id}', [VpsCategoryController::class, 'destroy'])->name('vps-category-delete');
        Route::get('/vps-country', [VpsCountryController::class, 'index'])->name('vps-country');
        Route::get('/vps-country-show/{id}', [VpsCountryController::class, 'show'])->name('vps-country-show');
        Route::post('/vps-country-store', [VpsCountryController::class, 'store'])->name('vps-country-store');
        Route::delete('/vps-country-delete/{id}', [VpsCountryController::class, 'destroy'])->name('vps-country-delete');
        Route::get('/vps-proxies', [VpsProxiesController::class, 'index'])->name('vps-proxies');
        Route::get('/vps-proxies-show/{id}', [VpsProxiesController::class, 'show'])->name('vps-proxies-show');
        Route::post('/vps-proxies-store', [VpsProxiesController::class, 'store'])->name('vps-proxies-store');
        Route::delete('/vps-proxies-restore/{id}', [VpsProxiesController::class, 'restore'])->name('vps-proxies-restore');
        Route::delete('/vps-proxies-destroy/{id}', [VpsProxiesController::class, 'destroy'])->name('vps-proxies-destroy');
        Route::get('/vps-detail', [VpsDetailController::class, 'index'])->name('vps-detail');
        Route::get('/vps-detail-show/{id}', [VpsDetailController::class, 'show'])->name('vps-detail-show');
        Route::post('/vps-detail-store', [VpsDetailController::class, 'store'])->name('vps-detail-store');
        Route::delete('/vps-detail-delete/{id}', [VpsDetailController::class, 'destroy'])->name('vps-detail-delete');
        Route::get('/vps-category-select', [VpsCategoryController::class, 'select2'])->name('vps-category-select');
        Route::get('/vps-server-select', [VpsServerController::class, 'select2'])->name('vps-server-select');
        Route::get('/vps-country-select', [VpsCountryController::class, 'select2'])->name('vps-country-select');
        Route::get('/vps-proxies-select', [VpsProxiesController::class, 'select2'])->name('vps-proxies-select');
        Route::get('/vps-detail-select', [VpsDetailController::class, 'select2'])->name('vps-detail-select');
        Route::get('/user-select', [UserController::class, 'select2'])->name('user-select');
        Route::get('/setting', [SettingController::class, 'index'])->name('setting');
        Route::post('/setting-store', [SettingController::class, 'store'])->name('setting-store');
        Route::post('/marzban/token', [MarzbanController::class, 'token'])->name('marzban.token');
        Route::get('/marzban/users/{id}', [MarzbanController::class, 'users'])->name('marzban.users');
        Route::get('/marzban/username/{id}/{username}', [MarzbanController::class, 'usersGetByUsername'])->name('marzban.username');
        Route::post('/marzban/users-add', [MarzbanController::class, 'usersAdd'])->name('marzban.users-add');
        Route::get('/marzban/system/{id}', [MarzbanController::class, 'system'])->name('marzban.system');
        Route::get('/marzban/inbounds/{id}', [MarzbanController::class, 'inbounds'])->name('marzban.inbounds');
    });
    //admin,member
    Route::middleware(['role:admin,member'])->prefix('member')->name('member.')->group(function () {
        Route::get('/account', [MemberAccountController::class, 'index'])->name('account');
        Route::post('/account', [MemberAccountController::class, 'update']);
        Route::post('/account-change-password', [MemberAccountController::class, 'changePassword'])->name('account.change.password');
        Route::middleware(['check.user.data'])->group(function () {
            Route::get('/', [MemberProductController::class, 'index'])->name('index');
            Route::get('/information', [MemberInformationController::class, 'index'])->name('information');
            Route::get('/product', [MemberProductController::class, 'index'])->name('product');
            Route::post('/product-store', [MemberProductController::class, 'store'])->name('product-store');
            Route::get('/product-list', [MemberProductController::class, 'list'])->name('product-list');
            Route::get('/product-detail/{id}', [MemberProductController::class, 'show'])->name('product-detail');
            Route::post('/product-uuid', [MemberProductController::class, 'uuid'])->name('product-uuid');
            Route::post('/product-delete', [MemberProductController::class, 'destroy'])->name('product-delete');
            Route::post('/balance-topup', [TripayController::class, 'create'])->name('balance-topup');
            Route::get('/balance', [MemberBalanceController::class, 'index'])->name('balance');
            Route::get('/balance-history', [MemberBalanceController::class, 'history'])->name('balance.history');
            Route::get('/invoice', [MemberInvoiceController::class, 'index'])->name('invoice');
            Route::get('/server-status', function () {
                return view('member.server_status');
            })->name('server_status');
            Route::get('/vps-server-ipaddress/{id}', [VpsServerController::class, 'ipAddress'])->name('vps-server-ipaddress');
        });
    });
});
