#!/bin/bash
sfile="https://boatgoesbinted.biz.id"

# ---- Konfigurasi default fail2ban) ----
BANTIME="1h"          # contoh: 1h, 10m, 86400 (detik)
FINDTIME="10m"
MAXRETRY="5"
IGNOREIP_DEFAULT="127.0.0.1/8 ::1 10.0.0.0/8 172.16.0.0/12 192.168.0.0/16"
BANACTION="nftables-multiport"   # Debian 12: nftables default
DIR="/etc/x-ui"
mkdir -p /etc/x-ui

#Input
read -rp "Masukkan Email anda: " email
read -rp "Masukkan Domain: " domain
read -rp "Masukkan Token BOT: " TGTOKEN
read -rp "Masukkan ChatID: " TGCHAT
echo "$domain" > $DIR/domain
domain=$(cat $DIR/domain)
echo "127.0.0.1" > $DIR/api_host
echo "YKxhBY4bnh2z4jnJZ+UaGQ==" > $DIR/ss2022psk
echo "TG_NOTIFY_TOKEN=$TGTOKEN" > "/usr/local/sbin/3ling-notify.conf"
echo "TG_NOTIFY_CHAT_ID=$TGCHAT" >> "/usr/local/sbin/3ling-notify.conf"

#Preparation
clear
cd;
apt-get update;

#Remove unused Module
apt-get -y --purge remove samba*;
apt-get -y --purge remove apache2*;
apt-get -y --purge remove sendmail*;
apt-get -y --purge remove bind9*;

#install benchmark
wget -O /usr/bin/bench "https://raw.githubusercontent.com/teddysun/across/master/bench.sh" && chmod +x /usr/bin/bench

#install toolkit
apt-get install git libio-socket-inet6-perl libsocket6-perl libcrypt-ssleay-perl libnet-libidn-perl perl libio-socket-ssl-perl libwww-perl libpcre3 libpcre3-dev zlib1g-dev dbus iftop zip unzip wget net-tools curl nano sed screen gnupg gnupg1 bc apt-transport-https build-essential dirmngr dnsutils sudo at htop iptables bsdmainutils cron lsof lnav jq -y

#Install lolcat
apt-get install -y ruby;
gem install lolcat;

#Set Timezone GMT+7
timedatectl set-timezone Asia/Jakarta;

#Install 3XUI
printf 'y\n2053\n' | bash <(curl -Ls https://raw.githubusercontent.com/mhsanaei/3x-ui/master/install.sh) | tee /root/3xui-install.log

#install GeoSite & GeoIP Custom
wget -O /usr/local/x-ui/bin/geositeindo.dat "$sfile/3xui/GeoSite.dat"
chmod +x /usr/local/x-ui/bin/geositeindo.dat
wget -O /usr/local/x-ui/bin/geoip.dat "$sfile/3xui/GeoIP.dat"
chmod +x /usr/local/x-ui/bin/geoip.dat

#profile
echo -e 'profile' >> /root/.profile
wget -O /usr/local/sbin/profile "$sfile/3xui/profile";
chmod +x /usr/local/sbin/profile
apt install neofetch -y

#Install VNSTAT
apt -y install vnstat
/etc/init.d/vnstat restart
apt -y install libsqlite3-dev
wget $sfile/3xui/vnstat-2.6.tar.gz
tar zxvf vnstat-2.6.tar.gz
cd vnstat-2.6
./configure --prefix=/usr --sysconfdir=/etc && make && make install 
cd
chown vnstat:vnstat /var/lib/vnstat -R
systemctl enable vnstat
/etc/init.d/vnstat restart
rm -f /root/vnstat-2.6.tar.gz 
rm -rf /root/vnstat-2.6

#Install Speedtest
curl -s https://packagecloud.io/install/repositories/ookla/speedtest-cli/script.deb.sh | sudo bash
sudo apt-get install speedtest -y

#install gotop
git clone --depth 1 https://github.com/cjbassi/gotop /tmp/gotop
/tmp/gotop/scripts/download.sh
cp /root/gotop /usr/bin/
chmod +x /usr/bin/gotop
cd

#install nginx
apt install nginx -y
mkdir -p /var/log/nginx
touch /var/log/nginx/access.log
touch /var/log/nginx/error.log
cat >/etc/nginx/nginx.conf <<'NGINX'
user  www-data;
worker_processes  3;
pid /run/nginx.pid;

#error_log  logs/error.log;
#error_log  logs/error.log  notice;
#error_log  logs/error.log  info;

#pid        logs/nginx.pid;


events {
    worker_connections  4096;
}


http {
    include       mime.types;
    default_type  application/octet-stream;

    log_format  main  '$remote_addr - $remote_user [$time_local] "$request" '
                      '$status $body_bytes_sent "$http_referer" '
                      '"$http_user_agent" "$http_x_forwarded_for"';

    #access_log  logs/access.log  main;

    sendfile       on;
    tcp_nopush     on;
    tcp_nodelay    on;
    keepalive_timeout  65;
    types_hash_max_size 2048;
    #gzip  on;


    # another virtual host using mix of IP-, name-, and port-based configuration
    #
    #server {
    #    listen       8000;
    #    listen       somename:8080;
    #    server_name  somename  alias  another.alias;

    #    location / {
    #        root   html;
    #        index  index.html index.htm;
    #    }
    #}


    # HTTPS server
    #
    #server {
    #    listen       443 ssl;
    #    server_name  localhost;

    #    ssl_certificate      cert.pem;
    #    ssl_certificate_key  cert.key;

    #    ssl_session_cache    shared:SSL:1m;
    #    ssl_session_timeout  5m;

    #    ssl_ciphers  HIGH:!aNULL:!MD5;
    #    ssl_prefer_server_ciphers  on;

    #    location / {
    #        root   html;
    #        index  index.html index.htm;
    #    }
    #}

include conf.d/*.conf;
}
NGINX
cat >/etc/nginx/conf.d/default.conf <<'NGINX1'
server {
  listen       8081;
  server_name  127.0.0.1 localhost;
  access_log /var/log/nginx/access.log;
  error_log /var/log/nginx/error.log error;
  root   /var/www/html;

  location / {
    index  index.html index.htm index.php;
    try_files $uri $uri/ /index.php?$args;
  }

  location ~ \.php$ {
    include /etc/nginx/fastcgi_params;
    fastcgi_pass  127.0.0.1:9000;
    fastcgi_index index.php;
    fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
  }
}
NGINX1
mkdir -p /var/www/html
wget -q -O /var/www/html/index.html "$sfile/3xui/index.html"
systemctl stop nginx

#install socat
apt install iptables -y
apt install curl socat xz-utils wget apt-transport-https gnupg gnupg2 gnupg1 dnsutils lsb-release -y 
apt install socat cron bash-completion -y

#install cert
systemctl stop x-ui
curl https://get.acme.sh | sh -s email=$email
/root/.acme.sh/acme.sh --server letsencrypt --register-account -m $email --issue -d $domain --standalone -k ec-256 --debug
~/.acme.sh/acme.sh --installcert -d $domain --fullchainpath /etc/x-ui/xray.crt --keypath /etc/x-ui/xray.key --ecc

#install command
cd /usr/local/sbin
wget -q -O 3ling "$sfile/3xui/3ling" && chmod +x 3ling
wget -q -O 3ling-svc "$sfile/3xui/3ling-svc" && chmod +x 3ling-svc
wget -q -O menu "$sfile/3xui/menu" && chmod +x menu
wget -q -O menu-3ling "$sfile/3xui/menu-3ling" && chmod +x menu-3ling
cd

#install Firewall
apt install ufw -y
sudo ufw default deny incoming
sudo ufw default allow outgoing
sudo ufw allow ssh
sudo ufw allow http
sudo ufw allow https
yes | sudo ufw enable
systemctl enable ufw
systemctl start ufw

#install fail2ban
export DEBIAN_FRONTEND=noninteractive
apt-get install -y fail2ban

# Cek apakah rsyslog ada & auth.log tersedia
AUTH_LOG="/var/log/auth.log"
HAS_AUTHLOG="no"
if [[ -f "$AUTH_LOG" ]]; then
  HAS_AUTHLOG="yes"
fi

# Kalau mau pakai file log tapi belum ada auth.log, boleh enable rsyslog
# Uncomment baris berikut jika kamu LEBIH SUKA backend file:
# apt-get install -y rsyslog
# systemctl enable --now rsyslog
# sleep 2
# [[ -f "$AUTH_LOG" ]] && HAS_AUTHLOG="yes"

# Pastikan direktori konfigurasi ada
mkdir -p /etc/fail2ban/

# Tulis konfigurasi umum di jail.local
cat >/etc/fail2ban/jail.local <<EOF
[DEFAULT]
# Warning allowipv6 hilang dengan set eksplisit
allowipv6 = auto
ignoreip = ${IGNOREIP_DEFAULT}
bantime = ${BANTIME}
findtime = ${FINDTIME}
maxretry = ${MAXRETRY}
banaction = ${BANACTION}
EOF
# Buat jail sshd sesuai backend yang tersedia
if [[ "${HAS_AUTHLOG}" == "yes" ]]; then
  # Backend file (auth.log)
  cat >>/etc/fail2ban/jail.local <<'EOF'

[sshd]
enabled = true
port    = ssh
filter  = sshd
backend = auto
logpath = /var/log/auth.log
mode    = aggressive
EOF
else
  # Backend systemd/journal
  cat >>/etc/fail2ban/jail.local <<'EOF'

[sshd]
enabled       = true
port          = ssh
filter        = sshd
backend       = systemd
# Debian 12 service name "ssh.service"
journalmatch  = _SYSTEMD_UNIT=ssh.service
mode          = aggressive
EOF
fi

# Buat folder override kalau belum ada
install -d -m 0755 /etc/fail2ban/fail2ban.d

# Tambahkan allowipv6 di [Definition]
tee /etc/fail2ban/fail2ban.d/allowipv6.local >/dev/null <<'EOF'
[Definition]
allowipv6 = auto
EOF

# Hidupkan & cek Fail2ban
systemctl daemon-reload
systemctl enable --now fail2ban
systemctl restart fail2ban

# Tampilkan status ringkas
echo "== Fail2ban service =="
systemctl --no-pager --full status fail2ban || true
echo
echo "== Fail2ban jails =="
fail2ban-client status || true
echo
echo "== sshd jail =="
fail2ban-client status sshd || true

#install database & config.json
command -v sqlite3 >/dev/null 2>&1 || apt-get update -y && apt-get install -y sqlite3
wget -O /usr/local/x-ui/bin/config.json "$sfile/3xui/config.json"
wget -O /root/old.db "$sfile/3xui/x-ui.db"
cp /etc/x-ui/x-ui.db /root/new.db
wget -O /root/migrate_xui.sql "$sfile/3xui/migrate_xui.sql"
cp /root/new.db "/root/new.db.bak.$(date +%F_%H%M%S)"
sqlite3 /root/new.db < /root/migrate_xui.sql
cp /root/new.db /etc/x-ui/x-ui.db
chown root:root /etc/x-ui/x-ui.db
chmod 600 /etc/x-ui/x-ui.db

#install CF
wget -O /root/warp "https://raw.githubusercontent.com/hamid-gh98/x-ui-scripts/main/install_warp_proxy.sh"
chmod +x /root/warp
bash /root/warp -y
rm /root/warp

#Correcting
LOG=/root/3xui-install.log
CLEAN=/root/3xui-install.clean
OUT=/etc/x-ui
install -d -m 755 "$OUT"
# Bersihkan \r dan ANSI color codes
sed -r 's/\r//g; s/\x1B\[[0-9;]*[A-Za-z]//g' "$LOG" > "$CLEAN"
grep -E '^Username:[[:space:]]+'    "$CLEAN" | tail -1 | sed 's/^Username:[[:space:]]*//'    > "$OUT/username"
grep -E '^Password:[[:space:]]+'    "$CLEAN" | tail -1 | sed 's/^Password:[[:space:]]*//'    > "$OUT/password"
grep -E '^Port:[[:space:]]+'        "$CLEAN" | tail -1 | sed 's/^Port:[[:space:]]*//'        > "$OUT/api_port"
wb=$(grep -E '^WebBasePath:[[:space:]]+' "$CLEAN" | tail -1 | sed 's/^WebBasePath:[[:space:]]*//')
[[ "$wb" != /* ]] && wb="/$wb"; [[ "$wb" != */ ]] && wb="$wb/"
printf '%s' "$wb" > "$OUT/webbasepath"
grep -E '^Access URL:[[:space:]]+' "$CLEAN" | tail -1 | sed 's/^Access URL:[[:space:]]*//' > "$OUT/access_url"
chmod 600 "$OUT/username" "$OUT/password" "$OUT/webbasepath" "$OUT/api_port" "$OUT/access_url" 2>/dev/null
echo "Username:    $(cat "$OUT/username")"
echo "Password:    $(cat "$OUT/password")"
echo "API Port:    $(cat "$OUT/api_port")"
echo "WebBasePath: $(cat "$OUT/webbasepath")"
echo "Access URL:  $(cat "$OUT/access_url")"
neofetch
sed -i '/info title/d' ~/.config/neofetch/config.conf
sed -i '/info "Packages" packages/d' ~/.config/neofetch/config.conf
sed -i '/info "Shell" shell/d' ~/.config/neofetch/config.conf
sed -i '/info "Resolution" resolution/d' ~/.config/neofetch/config.conf
sed -i '/info "Memory" memory/d' ~/.config/neofetch/config.conf

#finishing
apt autoremove -y
apt clean
profile
systemctl restart x-ui
WEBPATH=$(cat /etc/x-ui/webbasepath)
USERNAME=$(cat /etc/x-ui/username)
PASSWORD=$(cat /etc/x-ui/password)
cat >/etc/nginx/conf.d/xray.conf <<'NGINX2'
server {
        listen 127.0.0.1:1997 proxy_protocol default_server;
        listen 127.0.0.1:1998 http2 proxy_protocol default_server;
        server_name ${domain};
        set_real_ip_from 127.0.0.0/8;
#ips-v4:
        set_real_ip_from 103.21.244.0/22;
        set_real_ip_from 103.22.200.0/22;
        set_real_ip_from 103.31.4.0/22;
        set_real_ip_from 104.16.0.0/13;
        set_real_ip_from 104.24.0.0/14;
        set_real_ip_from 108.162.192.0/18;
        set_real_ip_from 131.0.72.0/22;
        set_real_ip_from 141.101.64.0/18;
        set_real_ip_from 162.158.0.0/15;
        set_real_ip_from 172.64.0.0/13;
        set_real_ip_from 173.245.48.0/20;
        set_real_ip_from 188.114.96.0/20;
        set_real_ip_from 190.93.240.0/20;
        set_real_ip_from 197.234.240.0/22;
        set_real_ip_from 198.41.128.0/17;
#ips-v6:
        set_real_ip_from 2400:cb00::/32;
        set_real_ip_from 2606:4700::/32;
        set_real_ip_from 2803:f800::/32;
        set_real_ip_from 2405:b500::/32;
        set_real_ip_from 2405:8100::/32;
        set_real_ip_from 2a06:98c0::/29;
        set_real_ip_from 2c0f:f248::/32;
        #real_ip_header CF-Connecting-IP;
        real_ip_header X-Forwarded-For;
        root /var/www/html;

# panel via prefix
location ${WEBPATH} {
proxy_set_header Host $host;
proxy_set_header X-Real-IP $remote_addr;
proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
proxy_set_header X-Forwarded-Proto https;
proxy_pass http://127.0.0.1:2053;
}
location /sub {
proxy_set_header Host $host;
proxy_set_header X-Real-IP $remote_addr;
proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
proxy_set_header X-Forwarded-Proto https;
proxy_pass http://127.0.0.1:2096;
}
location ~ /trojan-ws {
if ($http_upgrade != "Upgrade") {
rewrite /(.*) /trojan-ws break;
}
proxy_redirect off;
proxy_pass http://127.0.0.1:1001;
proxy_connect_timeout 4s;
proxy_read_timeout 120s;
proxy_send_timeout 12s;
proxy_http_version 1.1;
proxy_set_header X-Real-IP $remote_addr;
proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
proxy_set_header Upgrade $http_upgrade;
proxy_set_header Connection "upgrade";
proxy_set_header Host $http_host;
}
location ~ /vless-ws {
if ($http_upgrade != "Upgrade") {
rewrite /(.*) /vless-ws break;
}
proxy_redirect off;
proxy_pass http://127.0.0.1:2001;
proxy_connect_timeout 4s;
proxy_read_timeout 120s;
proxy_send_timeout 12s;
proxy_http_version 1.1;
proxy_set_header X-Real-IP $remote_addr;
proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
proxy_set_header Upgrade $http_upgrade;
proxy_set_header Connection "upgrade";
proxy_set_header Host $http_host;
}
location ~ /vmess-ws {
if ($http_upgrade != "Upgrade") {
rewrite /(.*) /vmess-ws break;
}
proxy_redirect off;
proxy_pass http://127.0.0.1:3001;
proxy_connect_timeout 4s;
proxy_read_timeout 120s;
proxy_send_timeout 12s;
proxy_http_version 1.1;
proxy_set_header X-Real-IP $remote_addr;
proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
proxy_set_header Upgrade $http_upgrade;
proxy_set_header Connection "upgrade";
proxy_set_header Host $http_host;
}
location ~ /ss2022-ws {
if ($http_upgrade != "Upgrade") {
rewrite /(.*) /ss2022-ws break;
}
proxy_redirect off;
proxy_pass http://127.0.0.1:4001;
proxy_connect_timeout 4s;
proxy_read_timeout 120s;
proxy_send_timeout 12s;
proxy_http_version 1.1;
proxy_set_header X-Real-IP $remote_addr;
proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
proxy_set_header Upgrade $http_upgrade;
proxy_set_header Connection "upgrade";
proxy_set_header Host $http_host;
}
location ^~ /trojan-service {
            if ($request_method != "POST") {
                return 404;
}
client_body_buffer_size 1m;
client_body_timeout 1h;
client_max_body_size 0;
grpc_read_timeout 1h;
grpc_send_timeout 1h;
grpc_set_header Host $host;
grpc_set_header X-Real-IP $remote_addr;
grpc_pass grpc://127.0.0.1:1003;
}
location ^~ /vless-service {
            if ($request_method != "POST") {
                return 404;
}
client_body_buffer_size 1m;
client_body_timeout 1h;
client_max_body_size 0;
grpc_read_timeout 1h;
grpc_send_timeout 1h;
grpc_set_header Host $host;
grpc_set_header X-Real-IP $remote_addr;
grpc_pass grpc://127.0.0.1:2003;
}
location ^~ /vmess-service {
            if ($request_method != "POST") {
                return 404;
}
client_body_buffer_size 1m;
client_body_timeout 1h;
client_max_body_size 0;
grpc_read_timeout 1h;
grpc_send_timeout 1h;
grpc_set_header Host $host;
grpc_set_header X-Real-IP $remote_addr;
grpc_pass grpc://127.0.0.1:3003;
    }
}
NGINX2
echo "Untuk data login dashboard 3XUI: "
echo "-=================================-"
echo "URL       : https://${domain}${WEBPATH}"
echo "username  : ${USERNAME}"
echo "password  : ${PASSWORD}"
echo "-=================================-"
echo "Script telah berhasil di install"
systemctl start nginx
rm /root/install.sh