<?php

namespace App\Http\Controllers\Member;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\VpsDetail;
use App\Models\VpsSubscription;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AccountController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user = auth()->user();

        return view('member.account', compact('user'));
    }

    public function trial()
    {
        $user = auth()->user();
        $now = Carbon::now('Asia/Jakarta');
        $vps_subscription = VpsSubscription::where('pay_at', '>=', $now)->get();
        foreach ($vps_subscription as $key => $value) {
            $vps_detail = VpsDetail::find($value->vps_details_id);
            $amount = $user->amount - $vps_detail->price_hour;
            if ($amount > 0) {
                $user->amount = $amount;
            } else {
                $user->amount = 0;
            }
        }
        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function amount()
    {
        $user = auth()->user();
        $now = Carbon::now('Asia/Jakarta');
        $vps_subscription = VpsSubscription::where('pay_at', '>=', $now)->get();
        foreach ($vps_subscription as $key => $value) {
            $vps_detail = VpsDetail::find($value->vps_details_id);
            $amount = $user->amount - $vps_detail->price_hour;
            if ($amount > 0) {
                $user->amount = $amount;
            } else {
                $user->amount = 0;
            }
        }
        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }
}
