<?php

namespace App\Http\Controllers\Admin;

use App\Models\Information;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Yajra\DataTables\DataTables;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rule;

class InformationController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = Information::query();
            return Datatables::of($data)
                ->addIndexColumn()
                ->editColumn('start_at', function ($row) {
                    return $row->start_at ? Carbon::parse($row->start_at)->format('d-m-Y H:i:s') : null;
                })
                ->editColumn('expires_at', function ($row) {
                    return $row->expires_at ? Carbon::parse($row->expires_at)->format('d-m-Y H:i:s') : null;
                })
                ->addColumn('action', function ($row) {
                    $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Edit" class="btn btn-primary btn-xs editData"><i class="fa fa-edit"></i></a>';
                    $btn = $btn . ' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Delete" class="btn btn-danger btn-xs deleteData"><i class="fa fa-trash"></i></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('admin.information');
    }

    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'name' => [
                'required',
                Rule::unique('informations')->ignore($request->id),
            ],
            'description' => 'required',
            'start_at' => 'required',
            'start_at_time' => 'required',
            'category' => 'required',
        ]);

        Information::updateOrCreate(
            [
                'id' => $request->id
            ],
            [
                'category' => $request->category,
                'name' => $request->name,
                'description' => $request->description,
                'start_at' => $request->start_at . ' ' . $request->start_at_time,
                'expires_at' => $request->expires_at . ' ' . $request->expires_at_time,
                'is_product' => $request->is_product ? 1 : 0,
                'is_pricing' => $request->is_pricing ? 1 : 0,
                'is_blog' => $request->is_blog ? 1 : 0,
                'is_billing' => $request->is_billing ? 1 : 0,
                'is_info' => $request->is_info ? 1 : 0,
            ]
        );

        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function show($id): JsonResponse
    {
        $data = Information::find($id);

        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => $data,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function destroy(Request $request): JsonResponse
    {
        $request->validate([
            'id' => 'required|integer|exists:informations,id',
        ]);
        $updated = Information::find($request->id)?->delete();
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $updated ? 200 : 404,
                'message' => $updated ? 'OK' : 'Record not found or already inactive',
            ]
        ], $updated ? 200 : 404);
    }
}
