<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Setting;

class SettingController extends Controller
{
    public function index(Request $request)
    {
        $setting = Setting::find('1');

        return view('admin.setting', compact('setting'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'address1' => 'required',
            'address2' => 'required',
            'city' => 'required',
            'postal_code' => 'required',
            'region' => 'required',
            'min_amount' => 'required',
            'min_amount_ip' => 'required',
            'payment_expired' => 'required',
        ]);

        Setting::updateOrCreate(
            [
                'id' => '1'
            ],
            [
                'name' => $request->name,
                'email' => $request->email,
                'phone' => $request->phone,
                'address1' => $request->address1,
                'address2' => $request->address2,
                'city' => $request->city,
                'postal_code' => $request->postal_code,
                'region' => $request->region,
                'email' => $request->email,
                'min_amount' => str_replace(',', '', $request->min_amount),
                'min_amount_ip' => str_replace(',', '', $request->min_amount_ip),
                'payment_expired' => $request->payment_expired,
            ]
        );

        return redirect()->route('admin.setting')
            ->with('success', 'Setting updated successfully!');
    }
}
