<?php

namespace App\Http\Controllers\Admin;

use App\Models\VpsSubscription;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;

class SubscriptionController extends Controller
{
    public function index(Request $request)
    {

        if ($request->ajax()) {

            $data = VpsSubscription::join('vps_details', 'vps_details.id', '=', 'vps_subscriptions.vps_details_id')
                ->join('vps', 'vps.id', '=', 'vps_details.vps_id')
                ->join('vps_proxies', 'vps_proxies.id', '=', 'vps_details.vps_proxies_id')
                ->join('users', 'users.id', '=', 'vps_subscriptions.user_id')
                ->select(
                    'vps_subscriptions.*',
                    'vps.name as vps_name',
                    'vps_proxies.name as vps_proxies_name',
                    'users.email as email'
                );

            return Datatables::of($data)
                ->addIndexColumn()
                ->editColumn('created_at', function ($row) {
                    return $row->created_at->format('d-m-Y H:i:s');
                })
                ->addColumn('action', function ($row) {
                    $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Config" class="btn btn-secondary btn-xs configData"><i class="fa fa-cogs"></i></a>';
                    $btn = $btn . ' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Edit" class="btn btn-primary btn-xs editData"><i class="fa fa-edit"></i></a>';
                    $btn = $btn . ' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Delete" class="btn btn-danger btn-xs deleteData"><i class="fa fa-trash"></i></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('admin.subscription');
    }

    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'user_id' => 'required',
            'vps_details_id' => 'required',
            'username' => 'required',
            'password' => 'required',
        ]);

        VpsSubscription::updateOrCreate(
            [
                'id' => $request->id
            ],
            [
                'user_id' => $request->user_id,
                'vps_details_id' => $request->vps_details_id,
                'username' => $request->username,
                'password' => $request->password,
            ]
        );

        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function show($id): JsonResponse
    {
        $data = VpsSubscription::find($id);

        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => $data,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function destroy(Request $request): JsonResponse
    {
        $request->validate([
            'id' => 'required|integer|exists:vps_subscriptions,id',
        ]);
        $updated = VpsSubscription::find($request->id)?->delete();
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $updated ? 200 : 404,
                'message' => $updated ? 'OK' : 'Record not found or already inactive',
            ]
        ], $updated ? 200 : 404);
    }
}
