<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Models\VpsDetail;
use Illuminate\Validation\Rule;

class VpsSubscriptionController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = VpsDetail::join('vps', 'vps.id', '=', 'vps_details.vps_id')
                ->join('vps_proxies', 'vps_proxies.id', '=', 'vps_details.vps_proxies_id')
                ->select('vps_details.*', 'vps.name as vps_name', 'vps_proxies.name as vps_proxies_name');
            return Datatables::of($data)
                ->addIndexColumn()
                ->editColumn('expires_at', function ($row) {
                    return $row->created_at->format('d-m-Y H:i:s');
                })
                ->addColumn('action', function ($row) {
                    $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Edit" class="btn btn-primary btn-xs editData"><i class="fa fa-edit"></i></a>';
                    $btn = $btn . ' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Delete" class="btn btn-danger btn-xs deleteData"><i class="fa fa-trash"></i></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
        return view('admin.vps_subscription');
    }

    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'vps_id' => [
                'required',
                Rule::unique('vps_details')->where(function ($query) use ($request) {
                    return $query->where('vps_proxies_id', $request->vps_proxies_id);
                })->ignore($request->id),
            ],
            'vps_proxies_id' => 'required',
            'price' => 'required',
            'price_hour' => 'required',
            'quota' => 'required',
        ], [
            'vps_id.unique' => 'vps and proxies already exists.',
        ]);

        VpsDetail::updateOrCreate(
            [
                'id' => $request->id
            ],
            [
                'vps_id' => $request->vps_id,
                'vps_proxies_id' => $request->vps_proxies_id,
                'price' => str_replace(',', '', $request->price),
                'price_hour' => str_replace(',', '', $request->price_hour),
                'quota' => str_replace(',', '', $request->quota),
            ]
        );

        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function show($id): JsonResponse
    {
        $data = VpsDetail::where('vps_details.id', $id)
            ->join('vps', 'vps.id', '=', 'vps_details.vps_id')
            ->join('vps_proxies', 'vps_proxies.id', '=', 'vps_details.vps_proxies_id')
            ->select('vps_details.*', 'vps.name as vps_name', 'vps_proxies.name as vps_proxies_name')->first();

        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => $data,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function destroy(Request $request): JsonResponse
    {
        VpsDetail::find($request->id)?->delete();
        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }
}
