<?php

namespace App\Http\Controllers\Member;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\VpsCategory;
use App\Models\VpsCountry;
use App\Models\VpsProxies;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class MemberAccountController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user = auth()->user();
        $vps_category = VpsCategory::orderBy('seq', 'asc')->get();
        $vps_country = VpsCountry::orderBy('seq', 'asc')->get();
        $vps_proxies = VpsProxies::orderBy('seq', 'asc')->get();

        return view('member.account', compact('user', 'vps_category', 'vps_country', 'vps_proxies'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {
        $request->validate([
            'firstname' => 'required|string',
            'lastname' => 'required|string',
            'username' => 'required|string',
            'phone' => 'required|numeric',
            'address1' => 'required|string',
            'address2' => 'required|string',
            'city' => 'required|string',
            'zip' => 'required|string',
            'region' => 'required|string',
        ]);
        $id = auth()->user()->id;
        $user = User::find($id);
        $user->name = $request->firstname . ' ' . $request->lastname;
        $user->firstname = $request->firstname;
        $user->lastname = $request->lastname;
        $user->username = $request->username;
        $user->phone = $request->phone;
        $user->address1 = $request->address1;
        $user->address2 = $request->address2;
        $user->city = $request->city;
        $user->zip = $request->zip;
        $user->region = $request->region;
        $user->save();
        return redirect()->route('member.account')
            ->with('success', 'Account updated successfully!');
    }

    /**
     * Update password the specified resource in storage.
     */
    public function changePassword(Request $request)
    {
        $request->validate([
            'password0' => 'required|string|min:8',
            'password1' => 'required|string|min:8',
            'password2' => 'required|string|min:8|same:password1',
        ], [
            'password0.required' => 'The current password field is required.',
            'password0.min' => 'The current password must be at least :min characters.',
            'password1.required' => 'The new password field is required.',
            'password1.min' => 'The new password must be at least :min characters.',
            'password2.required' => 'The confirm password field is required.',
            'password2.min' => 'The confirm password must be at least :min characters.',
            'password2.same' => 'The confirm password confirmation does not match.',
        ]);
        if (Auth::attempt(['email' => auth()->user()->email, 'password' => $request->password0])) {
            $id = auth()->user()->id;
            $user = User::find($id);
            $user->password = Hash::make($request->password1);
            $user->save();

            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();

            return redirect('/login');
        }
        return redirect()->route('member.account')
            ->with('failed', 'The current password is not correct!');
    }
}
