<?php

namespace App\Http\Controllers\Member;

use Carbon\Carbon;
use App\Models\Balance;
use App\Models\Setting;
use App\Models\Discount;
use App\Models\Information;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Models\VpsCategory;
use App\Models\VpsCountry;
use App\Models\VpsProxies;

class MemberBalanceController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user = auth()->user();
        $vps_category = VpsCategory::orderBy('seq', 'asc')->get();
        $vps_country = VpsCountry::orderBy('seq', 'asc')->get();
        $vps_proxies = VpsProxies::orderBy('seq', 'asc')->get();
        $information = Information::where(function ($query) {
            $query->where('expires_at', '>', Carbon::now('Asia/Jakarta'))
                ->orWhereNull('expires_at');
        })
            ->where('is_product', 1)
            ->get();
        $balance = 'IDR ' . number_format($user->amount, 2, '.', ',');
        $setting = Setting::find('1');

        return view('member.balance', compact('user', 'information', 'balance', 'setting', 'vps_category', 'vps_country', 'vps_proxies'));
    }

    public function history(Request $request)
    {
        if ($request->ajax()) {
            $user_id = auth()->user()->id;
            $data = Balance::join('discounts', 'discounts.id', '=', 'balances.discount_id', 'left')
                ->where('user_id', $user_id)
                ->orderBy('created_at', 'desc')
                ->select(
                    'balances.*',
                    'discounts.name as discount_name',
                    'discounts.code as discount_code',
                    'discounts.amount as discount_amount',
                    'discounts.amount_min as discount_amount_min',
                    'discounts.expires_at as discount_expires_at'
                );

            return Datatables::of($data)
                ->editColumn('discount_amount', function ($row) {
                    if ($row->discount_amount > 0) {
                        return $row->discount_code . ' - ' . $row->discount_name . ' (' . number_format($row->discount_amount, 0, '.', ',') . ')';
                    } else {
                        return '-';
                    }
                })->editColumn('created_at', function ($row) {
                    return $row->created_at->format('d-m-Y H:i:s');
                })
                ->addIndexColumn()
                ->addColumn('action', function ($row) {
                    $url = $row->pay_url ?? $row->checkout_url;
                    $btn = '<a href="' . $url . '" target="_blank" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Edit" class="btn btn-primary btn-xs editData"><i class="fa fa-book"></i></a>';
                    $btn = $btn . ' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Delete" class="btn btn-danger btn-xs deleteData"><i class="fa fa-trash"></i></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }
    }

    public function discount(Request $request): JsonResponse
    {
        $discount_code = $request->discount_code;
        $expires_at = Carbon::now('Asia/Jakarta');
        $discount = null;
        $code = 400;
        $message = 'Maaf, kode diskon yang Anda masukkan sudah tidak berlaku, tidak ditemukan, atau telah mencapai batas penggunaan.';
        if (!empty($discount_code)) {
            $discount = Discount::getDiscount($discount_code, $expires_at);
            if ($discount) {
                $code = 200;
                $message = 'OK';
            }
        }
        return response()->json([
            'response' => $discount,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }
}
