<?php

namespace App\Http\Controllers;

use App\Models\Information;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use App\Models\VpsCategory;

class WebsiteController extends Controller
{
    public function index(Request $request)
    {
        $information = Information::where(function ($query) {
            $query->where('expires_at', '>', Carbon::now('Asia/Jakarta'))
                ->orWhereNull('expires_at');
        })
            ->where('is_product', 1)
            ->get();

        return view('website.index', compact('information'));
    }

    public function pricing(Request $request)
    {
        $information = Information::where(function ($query) {
            $query->where('expires_at', '>', Carbon::now('Asia/Jakarta'))
                ->orWhereNull('expires_at');
        })
            ->where('is_pricing', 1)
            ->get();

        return view('website.pricing', compact('information'));
    }

    public function dataCenter(Request $request)
    {
        $information = Information::where('expires_at', '>', Carbon::now('Asia/Jakarta'))
            ->get();

        return view('website.data_center', compact('information'));
    }

    public function hostToIp(Request $request)
    {
        $information = Information::where('expires_at', '>', Carbon::now('Asia/Jakarta'))
            ->get();

        return view('website.host_to_ip', compact('information'));
    }

    public function hostToIpResolve(Request $request)
    {
        $request->validate([
            'hostname' => 'required',
            'g-recaptcha-response' => 'required|captcha',
        ]);
        $hostname = parse_url($request->hostname, PHP_URL_HOST) ?? $request->hostname;
        $ip = gethostbyname($hostname);
        if ($ip === $hostname) {
            return back()->withErrors(['failed' => 'Hostname could not be resolved.']);
        }

        return back()->with('ip', $ip);
    }

    public function blog(Request $request)
    {
        $information = Information::where('expires_at', '>', Carbon::now('Asia/Jakarta'))
            ->get();
        return view('website.blog', compact('information'));
    }

    public function sitemap(Request $request)
    {

        $information = Information::where('expires_at', '>', Carbon::now('Asia/Jakarta'))
            ->get();
        return view('website.sitemap', compact('information'));
    }

    public function termOfService(Request $request)
    {

        $information = Information::where('expires_at', '>', Carbon::now('Asia/Jakarta'))
            ->get();
        return view('website.term_of_service', compact('information'));
    }
    public function privacyPolicy(Request $request)
    {

        $information = Information::where('expires_at', '>', Carbon::now('Asia/Jakarta'))
            ->get();
        return view('website.privacy_policy', compact('information'));
    }

    public function disclaimer(Request $request)
    {

        $information = Information::where('expires_at', '>', Carbon::now('Asia/Jakarta'))
            ->get();
        return view('website.disclaimer', compact('information'));
    }
}
