<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Discount extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'code',
        'quota',
        'quota_used',
        'amount',
        'amount_min',
        'expires_at',
    ];

    protected $casts = [
        'expires_at' => 'datetime'
    ];

    public static function getDiscount($discount_code, $expires_at)
    {
        $data = Discount::where('code', $discount_code)
            ->whereColumn('quota_used', '<', 'quota')
            ->where('expires_at', '>=', $expires_at)
            ->select(
                'id',
                'code',
                'name',
                'amount',
                'amount_min',
            )
            ->first();

        return $data;
    }
}
