<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vps', function (Blueprint $table) {
            $table->id();
            $table->integer('vps_country_id')->index();
            $table->string('name')->unique();
            $table->string('speed');
            $table->string('description')->nullable();
            $table->enum('protocol', ['http', 'https'])->default('https');
            $table->string('hostname');
            $table->string('ipaddress');
            $table->string('username');
            $table->string('password');
            $table->string('token_type');
            $table->text('access_token');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vps');
    }
};
