<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('balances', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->string('merchant_ref')->index();
            $table->string('reference')->index()->nullable();
            $table->unsignedBigInteger('discount_id')->nullable();
            $table->decimal('discount_amount', 15, 2)->default(0);
            $table->decimal('amount_topup', 15, 2)->default(0);
            $table->decimal('total_amount', 15, 2)->default(0);
            $table->decimal('fee_merchant', 15, 2)->default(0);
            $table->decimal('fee_customer', 15, 2)->default(0);
            $table->decimal('total_fee', 15, 2)->default(0);
            $table->decimal('amount_received', 15, 2)->default(0);
            $table->string('payment_method')->nullable();
            $table->string('payment_name')->nullable();
            $table->string('pay_code')->nullable();
            $table->string('pay_url')->nullable();
            $table->string('checkout_url')->nullable();
            $table->string('currency', 3)->default('IDR');
            $table->enum('status', [
                'UNPAID',
                'PAID',
                'REFUND',
                'EXPIRED',
                'FAILED',
            ])->index()->nullable();
            $table->enum('is_closed_payment', [
                0,
                1,
            ])->default(0);
            $table->timestamp('paid_at')->nullable();
            $table->text('note')->nullable();
            $table->softDeletes();
            $table->timestamps();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('discount_id')->references('id')->on('discounts')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('balances');
    }
};
