@extends('layouts.admin')
@section('css')
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Invoice</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Invoice</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="card">
                <div class="card-body">
                    <div class="d-grid gap-2 d-md-flex mb-3">
                        <div class="row">
                            <div class="col-12 col-sm-3">
                                <div class="form-group">
                                    <label for="filterDate1">Start</label>
                                    <input type="date" class="form-control" id="filterDate1"
                                        value="{{ date('Y-m-01') }}">
                                </div>
                            </div>
                            <div class="col-12 col-sm-3">
                                <div class="form-group">
                                    <label for="filterDate2">End</label>
                                    <input type="date" class="form-control" id="filterDate2" value="{{ date('Y-m-d') }}">
                                </div>
                            </div>
                            <div class="col-12 col-sm-3">
                                <div class="form-group">
                                    <label for="filterStatus">Status</label>
                                    <select class="form-control" id="filterStatus">
                                        <option value="ALL">ALL</option>
                                        <option value="TOPUP">TOPUP</option>
                                        <option value="SUBSCRIPTION">SUBSCRIPTION</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-12 col-sm-3">
                                <div class="form-group">
                                    <label for="filterData">&nbsp;</label>
                                    <a class="btn btn-success form-control" href="javascript:void(0)" id="filterData"> <i
                                            class="fa fa-search"></i> Filter</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover text-nowrap data-table w-100" id="table1">
                            <thead>
                                <tr>
                                    <th class="text-center">No</th>
                                    <th class="text-center">Request Date</th>
                                    <th class="text-center">Trx ID</th>
                                    <th class="text-center">User</th>
                                    <th class="text-center">Product</th>
                                    <th class="text-center">Price</th>
                                    <th class="text-center">Initial Balance</th>
                                    <th class="text-center">New Balance</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <div class="modal fade" id="formModal1" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="formModalHeading1"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="dataForm1" name="dataForm1" class="form-horizontal">
                        <input type="hidden" name="id" id="id">
                        @csrf
                        <div class="alert alert-danger print-error-msg" style="display:none">
                            <ul></ul>
                        </div>

                        <div class="form-group">
                            <label for="name" class="col-sm-2 control-label">Name</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="name" name="name"
                                    placeholder="Enter Name">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="code" class="col-sm-2 control-label">Code</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="code" name="code"
                                    placeholder="Enter Code">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="quota" class="col-sm-2 control-label">Quota</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control quota" id="quota" name="quota"
                                    placeholder="Enter Quota">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="amount" class="col-sm-2 control-label">Amount</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control price" id="amount" name="amount"
                                    placeholder="Enter Amount">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="expires_at" class="col-sm-2 control-label">Expired</label>
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="col-6">
                                        <input type="date" class="form-control" id="expires_at" name="expires_at"
                                            placeholder="Enter Expired" value="{{ date('Y-m-d') }}">
                                    </div>
                                    <div class="col-6">
                                        <input type="time" class="form-control" id="expires_at_time"
                                            name="expires_at_time" placeholder="Enter Expired"
                                            value="{{ date('H:i') }}">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-offset-2 col-sm-10">
                            <button type="submit" class="btn btn-success mt-2" id="saveBtn">Submit</button>
                            <button type="button" class="btn btn-danger mt-2" id="cancelBtn" data-dismiss="modal"><i
                                    class="fa fa-cancel"></i>
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(function() {
            var table = $('#table1').DataTable({
                responsive: true,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('admin.invoice') }}",
                    data: function(d) {
                        d.date1 = $('#filterDate1').val();
                        d.date2 = $('#filterDate2').val();
                        d.status = $('#filterStatus').val();
                    }
                },
                order: [
                    [1, 'desc']
                ],
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false,
                        className: 'text-center'
                    },
                    {
                        data: 'created_at',
                        name: 'created_at',
                        className: 'text-center'
                    },
                    {
                        data: 'uuid',
                        name: 'uuid',
                        className: 'text-center'
                    },
                    {
                        data: 'email',
                        name: 'users.email',
                        className: 'text-center'
                    },
                    {
                        data: 'vps_name',
                        name: 'vps.name',
                        className: 'text-center'
                    },
                    {
                        data: 'price',
                        name: 'price',
                        className: 'text-right',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    },
                    {
                        data: 'initial_balance',
                        name: 'initial_balance',
                        className: 'text-right',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    },
                    {
                        data: 'new_balance',
                        name: 'new_balance',
                        className: 'text-right',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    }
                ]
            });

            $('#filterData').click(function() {
                table.draw();
            });
        });
    </script>
@endsection
