@extends('layouts.member')
@section('css')
    <style>
        a {
            color: #000000;
        }
    </style>
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>My IP</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">My IP</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <!-- Default box -->
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-sm-12 text-center">
                            <h5>My IP address</h5>
                            <h1 id="query"></h1>
                        </div>
                        <div class="col-sm-12">
                            <div class="table-responsive">
                                <table id="table1" class="table table-bordered table-striped">
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->

        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
@endsection
@section('js')
    <script>
        $(function() {
            $.ajax({
                type: "GET",
                url: "http://ip-api.com/json",
                dataType: "JSON"
            }).done(function(result) {
                $("#query").html(result.query);
                $("#table1 tbody").append("<tr><td>ISP</td><td>" + result.isp + "</td></tr>");
                $("#table1 tbody").append("<tr><td>Company</td><td>" + result.org + " | " + result.as +
                    "</td></tr>");
                $("#table1 tbody").append(
                    `<tr><td>Country</td><td><img style="width: 1.5rem" src="https://cdn.ipwhois.io/flags/${result.countryCode.toLowerCase()}.svg" alt="ID | Indonesia"> ${result.countryCode} | ${result.country}</td></tr>`
                );
                $("#table1 tbody").append("<tr><td>Region</td><td>" + result.region + " | " + result
                    .regionName + "</td></tr>");
                $("#table1 tbody").append("<tr><td>City</td><td>" + result.city + "</td></tr>");
                $("#table1 tbody").append("<tr><td>Latitude / Longitude</td><td>" + result.lat + " / " +
                    result
                    .lon + "</td></tr>");
                $("#table1 tbody").append("<tr><td>Timezone</td><td>" + result.timezone + "</td></tr>");
                $("#table1 tbody").append("<tr><td>ZIP</td><td>" + result.zip + "</td></tr>");
            });
        });
    </script>
@endsection
