@extends('layouts.member')
@section('css')
    <style>
        a {
            color: #000000;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            color: #fff;
            background-color: #343a40;
        }
    </style>
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>{{ Str::upper(Str::lower(request()->category)) }} -
                            {{ Str::upper(Str::lower(request()->proxies)) }}
                            - {{ Str::upper(Str::lower(request()->country)) }}
                        </h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">{{ Str::upper(Str::lower(request()->category)) }} -
                                {{ Str::upper(Str::lower(request()->proxies)) }} -
                                {{ Str::upper(Str::lower(request()->country)) }}</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <!-- Default box -->
            @foreach ($information as $item)
                <div class="alert alert-{{ $item->category }} alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    {{ $item->name }} {{ $item->description }}
                </div>
            @endforeach
            <div class="card">
                @if (count($vps_detail) <= 0)
                    <div class="text-center p-5">
                        <h4 class="rounded-pill bg-danger mt-2 p-2">Empty Account</h4>
                    </div>
                @endif
                <div class="row p-2">
                    @foreach ($vps_detail as $item)
                        <div class="col-sm-4">
                            <div class="card">
                                <div class="card-header text-center m-0 p-0">
                                    <h5 class="m-0 p-1">
                                        {{ $item->vps_name . ' - ' . $item->vps_proxies_name }}
                                    </h5>
                                </div>
                                <!-- /.card-header -->
                                <div class="card-body m-o p-1">
                                    <div class="row">
                                        <div class="col-6 text-left">
                                            <span><i class="me-1 md far fa-question-circle" role="img"
                                                    aria-label="help circle outline"></i>
                                                Status</span>
                                        </div>
                                        <div class="col-6 text-right">
                                            {!! $item->deleted_at == null
                                                ? '<strong class="text-success">active</strong>'
                                                : '<strong class="text-danger">disabled</strong>' !!}
                                        </div>
                                        <div class="col-6 text-left">
                                            <span><i class="me-1 md fa fa-globe" role="img"
                                                    aria-label="help circle outline"></i>
                                                Location</span>
                                        </div>
                                        <div class="col-6 text-right">
                                            <span>{{ $item->vps_country_name }}</span>
                                        </div>
                                        <div class="col-6 text-left">
                                            <span><i class="me-1 md far fa-check-circle" role="img"
                                                    aria-label="help circle outline"></i>
                                                Speed</span>
                                        </div>
                                        <div class="col-6 text-right">
                                            <span>Up To {{ $item->speed }}</span>
                                        </div>
                                        <div class="col-6 text-left">
                                            <span><i class="me-1 md fa fa-globe" role="img"
                                                    aria-label="help circle outline"></i>
                                                Max Session</span>
                                        </div>
                                        <div class="col-6 text-right">
                                            <span>{{ $item->max_session }} IP</span>
                                        </div>
                                        <div class="col-6 text-left">
                                            <span><i class="me-1 md fas fa-file-invoice-dollar" role="img"
                                                    aria-label="help circle outline"></i>
                                                Monthly Price</span>
                                        </div>
                                        <div class="col-6 text-right">
                                            <span>IDR {{ number_format($item->price, 0, '.', ',') }}</span>
                                        </div>
                                        <div class="col-6 text-left">
                                            <span><i class="me-1 md far fa-file-alt" role="img"
                                                    aria-label="help circle outline"></i>
                                                Hourly Price</span>
                                        </div>
                                        <div class="col-6 text-right">
                                            <span>IDR {{ number_format($item->price_hour, 2, '.', ',') }}</span>
                                        </div>
                                        <div class="col-6 text-left">
                                            <span><i class="me-1 md far fa-user-circle" role="img"
                                                    aria-label="help circle outline"></i>
                                                Quota</span>
                                        </div>
                                        <div class="col-6 text-right">
                                            <span>{{ $item->quota }}</span>
                                        </div>
                                        <div class="col-6 text-left">
                                            <span><i class="me-1 md far fa-user-circle" role="img"
                                                    aria-label="help circle outline"></i>
                                                Used</span>
                                        </div>
                                        <div class="col-6 text-right">
                                            <span>{{ $item->quota_used }}</span>
                                        </div>
                                        <div class="col-12 my-1">
                                            @if ($item->deleted_at != null)
                                                <button class="btn-block btn btn-sm btn-danger my-2">Maintenance</button>
                                            @elseif ($item->quota <= $item->quota_used)
                                                <button class="btn-block btn btn-sm btn-danger my-2">Out of Stock</button>
                                            @else
                                                <button class="btn-block btn btn-sm btn-dark my-2 select-account"
                                                    data-id="{{ $item->id }}"
                                                    data-proxies="{{ Str::upper(Str::lower(request()->proxies)) }}"
                                                    data-category="{{ Str::upper(Str::lower(request()->category)) }}"
                                                    data-server="{{ $item->vps_name }}"
                                                    data-country="{{ Str::upper(Str::lower($item->vps_country_code . ' - ' . $item->vps_country_name)) }}">Select</button>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <!-- /.card-body -->
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
        <!-- /.content -->
        {{-- <a id="createAccount" href="javascript:void(0)" class="btn btn-dark back-to-top img-circle text-center"
            role="button" aria-label="Create Account">
            <i class="fas fa-search"></i>
        </a> --}}
    </div>
    <!-- /.content-wrapper -->

    @include('member.product_modal')

    <div class="modal fade" id="formModal1">
        <div class="modal-dialog modal-sm modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Create Account</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="dataForm1" name="dataForm1" class="form-horizontal">
                        <input type="hidden" name="create_account_id" id="create_account_id">
                        @csrf
                        <div class="alert alert-danger print-error-msg" style="display:none">
                            <ul></ul>
                        </div>
                        <div class="row p-2">
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="create_account_category">Category Service</label>
                                    <input type="text" class="form-control" id="create_account_category"
                                        placeholder="Enter category" readonly>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="create_account_country">Location</label>
                                    <input type="text" class="form-control" id="create_account_country"
                                        placeholder="Enter location" readonly>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-group">
                                    <label for="create_account_server">Server Name</label>
                                    <input type="text" class="form-control" id="create_account_server"
                                        placeholder="Enter server name" readonly>
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <div class="form-group">
                                    <label for="create_account_username">Username</label>
                                    <input type="text" class="form-control" name="create_account_username"
                                        id="create_account_username" placeholder="Enter username" minlength="4"
                                        maxlength="15">
                                </div>
                            </div>
                            <div class="col-12 mb-3">
                                <button type="submit" class="btn form-control btn-dark" id="saveBtn">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->
@endsection
@section('js')
    <script>
        $(function() {
            $('.select-account').on('click', function() {
                $('#create_account_id').val($(this).data('id'));
                $('#create_account_category').val($(this).data('category') + ' - ' + $(this).data(
                    'proxies'));
                $('#create_account_server').val($(this).data('server'));
                $('#create_account_country').val($(this).data('country'));
                $('#formModal1').modal('show');
            });

            $('#dataForm1').submit(function(e) {
                e.preventDefault();
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                let formData = new FormData(this);
                $('#saveBtn').html('Sending...');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('member.product-store') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: (response) => {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').trigger("reset");
                        $('#formModal1').modal('hide');
                        toastr.success('create account successfully');
                        window.location.href = "{{ route('member.product') }}";
                    },
                    error: function(response) {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').find(".print-error-msg").find("ul").html('');
                        $('#dataForm1').find(".print-error-msg").css('display', 'block');
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#dataForm1').find(".print-error-msg").find("ul")
                                .append('<li>' + value + '</li>');
                        });
                    }
                });
            });
        });
    </script>
@endsection
