#!/usr/bin/env bash
sfile="https://boatgoesbinted.biz.id"
set -euo pipefail

# =========[ KONFIG USER ]=========
DOMAIN="${DOMAIN:-}"
TELEGRAM_BOT_TOKEN="${TELEGRAM_BOT_TOKEN:-}"     # opsional
TELEGRAM_CHAT_ID="${TELEGRAM_CHAT_ID:-}"         # opsional
SUB_SECRET="${SUB_SECRET:-GANTI_INI_PANJANG_BANGET_32-64CHAR}"  # rahasia HMAC subsrv
SUB_BASE_HTML="${SUB_BASE_HTML:-s22}"
SUB_BASE_JSON="${SUB_BASE_JSON:-s22j}"
TIMEZONE="${TIMEZONE:-Asia/Jakarta}"
SS_WSPATH="${SS_WSPATH:-/ss-ws}"
SS_METHOD="2022-blake3-aes-128-gcm"
XRAY_API_PORT=10085
SS_LISTEN_PORT=11000
PUBLIC_HTTPS_PORT=443

# =========[ CEK DEPENDENSI ]=========
need(){ command -v "$1" >/dev/null 2>&1 || { echo "Need: $1"; exit 1; }; }
need jq
need awk
need openssl
need docker
need bash

# =========[ install Xray ]=========
bash -c "$(curl -L https://github.com/XTLS/Xray-install/raw/main/install-release.sh)" @ install --version v25.6.8

# =========[ PATHS & FILES ]=========
XRAY_DIR="/usr/local/etc/xray"
XRAY_CFG="${XRAY_DIR}/config.json"
XRAY_DB="${XRAY_DIR}/database.json"
DOMAIN_FILE="/root/domain"
TG_CONF="/etc/gegevps/bin/telegram_config.conf"
LOG_DIR="/var/lib/marzban/assets"
ACCESS_LOG="${LOG_DIR}/access.log"
ERROR_LOG="${LOG_DIR}/error.log"

MARZBAN_DIR="/opt/marzban"
COMPOSE_FILE="${MARZBAN_DIR}/docker-compose.yml"
SUBSRV_PY="${MARZBAN_DIR}/subsrv.py"
SUBSRV_NAME="subsrv"

# =========[ GENERATE KUNCI SERVER SS2022 ]=========
SERVER_KEY_B64="$(openssl rand -base64 16)"

# =========[ TULIS KONFIG XRAY ]=========
cat > "$XRAY_CFG" <<JSON
{
  "log": {
    "access": "/var/lib/marzban/assets/access.log",
    "error": "/var/lib/marzban/assets/error.log",
    "loglevel": "warning"
  },
  "dns": {
    "servers": [
      "1.1.1.1",
      "1.0.0.1",
      "8.8.8.8",
      "8.8.4.4",
      "127.0.0.1"
    ],
    "tag": "dns-in"
  },
  "api": {
    "tag": "api",
    "services": [
      "HandlerService",
      "LoggerService",
      "StatsService"
    ]
  },
  "stats": {},
  "policy": {
    "levels": {
      "0": {
        "statsUserUplink": true,
        "statsUserDownlink": true
      }
    },
    "system": {
      "statsInboundUplink": false,
      "statsInboundDownlink": false
    }
  },
  "routing": {
    "domainStrategy": "IPIfNonMatch",
    "rules": [
      {
        "type": "field",
        "inboundTag": [
          "api"
        ],
        "outboundTag": "api"
      },
      {
        "type": "field",
        "port": "443",
        "network": "udp",
        "outboundTag": "block"
      },
      {
        "protocol": [
          "bittorrent"
        ],
        "outboundTag": "TORRENT",
        "type": "field"
      },
      {
        "type": "field",
        "inboundTag": [
          "dns-in"
        ],
        "outboundTag": "dns-out"
      },
      {
        "inboundTag": [
          "SSWS-ANTIPORN"
        ],
        "type": "field",
        "outboundTag": "block",
        "domain": [
          "ext:geositeindo.dat:oisd-nsfw"
        ]
      },
      {
        "inboundTag": [
          "SSWS-ANTIPORN",
          "SSWS-ANTIADS"
        ],
        "type": "field",
        "outboundTag": "block",
        "domain": [
          "ext:geositeindo.dat:oisd-full",
          "ext:geositeindo.dat:rule-ads"
        ]
      },
      {
        "type": "field",
        "network": "tcp,udp",
        "domain": [
          "geosite:openai",
          "domain:nevacloud.com",
          "domain:icanhazip.com",
          "domain:ipaddress.my",
          "domain:pajak.go.id",
          "domain:imagebam.com",
          "domain:expressvpn.com",
          "domain:surfshark.com",
          "domain:2ip.io",
          "domain:ifconfig.io",
          "ext:geositeindo.dat:rule-ipcheck",
          "domain:komiku.id",
          "domain:vk.com",
          "ext:geositeindo.dat:rule-speedtest",
          "domain:whatismyisp.com",
          "domain:nordvpn.com"
        ],
        "outboundTag": "warp-IPv4"
      },
      {
        "type": "field",
        "network": "tcp,udp",
        "domain": [
          "geosite:netflix",
          "ext:geositeindo.dat:rule-ipcheck"
        ],
        "outboundTag": "warp-IPv6"
      }
    ]
  },
  "inbounds": [
    {
      "listen": "127.0.0.1",
      "port": 10085,
      "protocol": "dokodemo-door",
      "settings": {
        "address": "127.0.0.1"
      },
      "tag": "api"
    },
    {
      "tag": "SSWS",
      "listen": "127.0.0.1",
      "port": 11000,
      "protocol": "shadowsocks",
      "settings": {
        "method": "2022-blake3-aes-128-gcm",
        "password": "${SERVER_KEY_B64}",
        "clients": [
          {
            "password": "4pMVMP2d5PMkf5tizmdfOA==",
            "email": "admin"
          }
        ],
        "network": "tcp,udp"
      },
      "streamSettings": {
        "network": "ws",
        "security": "none",
        "wsSettings": {
          "path": "/ss-ws"
        }
      },
      "sniffing": {
        "enabled": true,
        "destOverride": [
          "http",
          "tls",
          "quic"
        ]
      }
    },
    {
      "tag": "SSWS-ANTIADS",
      "listen": "127.0.0.1",
      "port": 11001,
      "protocol": "shadowsocks",
      "settings": {
        "method": "2022-blake3-aes-128-gcm",
        "password": "${SERVER_KEY_B64}",
        "clients": [
          {
            "password": "4pMVMP2d5PMkf5tizmdfOA==",
            "email": "admin"
          }
        ],
        "network": "tcp,udp"
      },
      "streamSettings": {
        "network": "ws",
        "security": "none",
        "wsSettings": {
          "acceptProxyProtocol": true,
          "path": "/ss-ws-antiads"
        }
      },
      "sniffing": {
        "enabled": true,
        "destOverride": [
          "http",
          "tls",
          "quic"
        ]
      }
    },
    {
      "tag": "SSWS-ANTIPORN",
      "listen": "127.0.0.1",
      "port": 11002,
      "protocol": "shadowsocks",
      "settings": {
        "method": "2022-blake3-aes-128-gcm",
        "password": "${SERVER_KEY_B64}",
        "clients": [
          {
            "password": "4pMVMP2d5PMkf5tizmdfOA==",
            "email": "admin"
          }
        ],
        "network": "tcp,udp"
      },
      "streamSettings": {
        "network": "ws",
        "security": "none",
        "wsSettings": {
          "acceptProxyProtocol": true,
          "path": "/ss-ws-antiporn"
        }
      },
      "sniffing": {
        "enabled": true,
        "destOverride": [
          "http",
          "tls",
          "quic"
        ]
      }
    }
  ],
  "outbounds": [
    {
      "protocol": "freedom",
      "settings": {
        "domainStrategy": "UseIPv4"
      },
      "tag": "direct"
    },
    {
      "tag": "block",
      "protocol": "blackhole",
      "settings": {
        "response": {
          "type": "http"
        }
      }
    },
    {
      "protocol": "blackhole",
      "tag": "TORRENT"
    },
    {
      "protocol": "dns",
      "settings": {
        "nonIPQuery": "skip"
      },
      "tag": "dns-out"
    },
    {
      "tag": "WARP",
      "protocol": "socks",
      "settings": {
        "servers": [
          {
            "address": "127.0.0.1",
            "port": 40000
          }
        ]
      }
    },
    {
      "protocol": "freedom",
      "settings": {
        "domainStrategy": "ForceIPv4"
      },
      "proxySettings": {
        "tag": "WARP"
      },
      "tag": "warp-IPv4"
    },
    {
      "protocol": "freedom",
      "settings": {
        "domainStrategy": "ForceIPv6"
      },
      "proxySettings": {
        "tag": "WARP"
      },
      "tag": "warp-IPv6"
    },
    {
      "protocol": "freedom",
      "tag": "api"
    }
  ]
}
JSON

cat > /usr/local/sbin/ss2022-restore-wait << 'SH'
#!/usr/bin/env bash
set -euo pipefail

XRAY_BIN="/usr/local/bin/xray"
SERVER="127.0.0.1:10085"

# Tunggu API Xray ready (maks 30 detik)
for i in {1..30}; do
  if "$XRAY_BIN" api lsi --server="$SERVER" >/dev/null 2>&1; then
    /usr/local/sbin/ss2022ctl restore
    exit $?
  fi
  sleep 1
done

echo "ERROR: Xray API not ready after 30s" >&2
exit 1
SH
chmod +x /usr/local/sbin/ss2022-restore-wait

cat > /etc/systemd/system/ss2022-enforcer.service << 'SH'
[Unit]
Description=SS2022 quota enforcer
After=network.target xray.service

[Service]
Type=oneshot
ExecStart=/usr/bin/flock -n /run/ss2022-enforcer.lock /usr/local/sbin/ss2022ctl enforce
RuntimeDirectory=ss2022-enforcer
TimeoutStartSec=120
Nice=10

# === Hardening (aman + bisa tulis DB) ===
ProtectSystem=strict
ProtectHome=yes
NoNewPrivileges=yes
PrivateTmp=yes
LockPersonality=yes
RestrictRealtime=yes
RestrictSUIDSGID=yes

# IZINKAN tulis di path berikut:
ReadWritePaths=/usr/local/etc/xray
ReadWritePaths=/var/lib/marzban
ReadWritePaths=/run
# (opsional) batasi resource
MemoryMax=150M
CPUQuota=50%
SH
cat > /etc/systemd/system/ss2022-enforcer.timer << 'SH'
[Unit]
Description=Run SS2022 quota enforcer periodically

[Timer]
OnBootSec=2min
OnUnitInactiveSec=60s     
AccuracySec=5s
RandomizedDelaySec=10s  
Unit=ss2022-enforcer.service
Persistent=true

[Install]
WantedBy=timers.target
SH

# =========[ SCRIPT UTAMA ]=========
wget -O /usr/local/sbin/ss2022ctl "$sfile/marzban/ss2022ctl.sh" && chmod +x /usr/local/sbin/ss2022ctl

# =========[ DB AWAL ]=========
[ -f "$XRAY_DB" ] || echo '{"users":{}}' > "$XRAY_DB"

# =========[ Install Geositeindo & GeositeIP ]=========
wget -O /usr/local/share/xray/geositeindo.dat "$sfile://marzban/GeoSite.dat" && chmod +x /usr/local/share/xray/geositeindo.dat
wget -O /usr/local/share/xray/geoip.dat "$sfile://marzban/GeoIP.dat" && chmod +x /usr/local/share/xray/geoip.dat

# =========[ SYSTEMD XRAY ]=========
mkdir -p /etc/systemd/system/xray.service.d
  cat > /etc/systemd/system/xray.service.d/override.conf <<'UNIT'
[Service]
# Pastikan restore dipanggil SETELAH Xray siap
ExecStartPost=/usr/local/sbin/ss2022-restore-wait
UNIT
chmod 777 /var/lib/marzban/assets/access.log 
chmod 777 /var/lib/marzban/assets/error.log
  systemctl daemon-reload
  systemctl enable --now ss2022-enforcer.timer
  systemctl enable xray
systemctl restart xray
sleep 1
/usr/local/bin/xray api lsi --server=127.0.0.1:${XRAY_API_PORT} >/dev/null && echo "Xray API OK di 127.0.0.1:${XRAY_API_PORT}"

# =========[ SUBSRV (Flask) =========
# Server subscription sederhana: baca XRAY_DB & ACCESS_LOG
wget -O /opt/marzban/subsrv.py "$sfile/marzban/subsrv.py" && chmod +x /opt/marzban/subsrv.py

# =========[ DOCKER-COMPOSE SUBSRV + NGINX PATH PROXY ]=========
wget -O /opt/marzban/docker-compose.yml "$sfile/marzban/docker-compose-ss2022.yml"
wget -O /opt/marzban/xray.conf "$sfile/marzban/xray-ss2022.conf"

#Update Docker
marzban restart

# =========[ INFO OUTPUT ]=========
echo
echo "===== DONE ====="
echo "Domain                     : $DOMAIN"
echo "WS path                    : $SS_WSPATH"
echo "Xray API                   : 127.0.0.1:${XRAY_API_PORT}"
echo "SS2022 (server key)        : ${SERVER_KEY_B64}"
echo "DB                         : ${XRAY_DB}"
echo "Access Log                 : ${ACCESS_LOG}"
echo "Sub Secret (subsrv)        : ${SUB_SECRET}"
echo
echo "Langkah selanjutnya:"
echo "1) Pastikan server block Nginx untuk ${DOMAIN} meng-include file: ${MARZBAN_DIR}/sub-locations.conf"
echo "2) Restart/Reload Nginx container bila perlu (contoh: docker compose exec -T nginx nginx -s reload)"
echo "3) Install ss2022ctl (kalau belum) & tambah user:"
echo "   - ss2022ctl add <email> <quota_gb> <expire_days> <reset_days> [max_devices]"
echo "   - ss2022ctl link <email>"
echo
echo "Contoh Subscription URL (token dihitung server):"
echo "  https://${DOMAIN}/${SUB_BASE_HTML}/<email>?token=<HMAC>"
