#!/bin/bash
sfile="https://boatgoesbinted.biz.id"

# ---- Konfigurasi default fail2ban) ----
BANTIME="1h"          # contoh: 1h, 10m, 86400 (detik)
FINDTIME="10m"
MAXRETRY="5"
IGNOREIP_DEFAULT="127.0.0.1/8 ::1 10.0.0.0/8 172.16.0.0/12 192.168.0.0/16"
BANACTION="nftables-multiport"   # Debian 12: nftables default

#email
read -rp "Masukkan Email anda: " email

#domain
read -rp "Masukkan Domain: " domain
echo "$domain" > /root/domain
domain=$(cat /root/domain)

#token
read -rp "Masukkan UsernamePanel: " userpanel
echo "$userpanel" > /root/userpanel
read -rp "Masukkan PasswordPanel: " passpanel
echo "$passpanel" > /root/passpanel

#nameregis
read -rp "Masukkan ISP VPS: " nama
echo "$nama" > /root/nama

#Pass Backup
read -rp "Masukkan Pass untuk file Backup: " fileb
echo "$fileb" > /root/passbackup

#Preparation
clear
cd;
apt-get update;

#Remove unused Module
apt-get -y --purge remove samba*;
apt-get -y --purge remove apache2*;
apt-get -y --purge remove sendmail*;
apt-get -y --purge remove bind9*;

#install sysctl
wget -O /etc/sysctl.conf "$sfile/marzban/sysctl.conf"
sysctl -p

#install benchmark
wget -O /usr/bin/bench "https://raw.githubusercontent.com/teddysun/across/master/bench.sh" && chmod +x /usr/bin/bench

#install toolkit
apt-get install git libio-socket-inet6-perl libsocket6-perl libcrypt-ssleay-perl libnet-libidn-perl perl libio-socket-ssl-perl libwww-perl libpcre3 libpcre3-dev zlib1g-dev dbus iftop zip unzip wget net-tools curl nano sed screen gnupg gnupg1 bc apt-transport-https build-essential dirmngr dnsutils sudo at htop iptables bsdmainutils cron lsof lnav -y

#Install lolcat
apt-get install -y ruby;
gem install lolcat;

#Set Timezone GMT+7
timedatectl set-timezone Asia/Jakarta;

#Install Marzban
sudo bash -c "$(curl -sL https://github.com/GawrAme/Marzban-scripts/raw/master/marzban.sh)" @ install

#install subs
wget -O /opt/marzban/index.html "$sfile/marzban/subs.html"

#install env
wget -O /opt/marzban/.env "$sfile/marzban/env"

#install compose
wget -O /opt/marzban/docker-compose.yml "$sfile/sshws/docker-compose.yml"

#install assets & core
mkdir -p /etc/autokill/logs
mkdir -p /etc/autokill/penalty_logs
mkdir -p /var/lib/marzban/assets
mkdir -p /var/lib/marzban/core
wget -O /var/lib/marzban/assets/geositeindo.dat "$sfile/marzban/GeoSite.dat"
chmod +x /var/lib/marzban/assets/geositeindo.dat
wget -O /var/lib/marzban/assets/geoip.dat "$sfile/marzban/GeoIP.dat"
chmod +x /var/lib/marzban/assets/geoip.dat
wget -O /var/lib/marzban/core/xray "$sfile/marzban/core/xray"
chmod +x /var/lib/marzban/core/xray

#profile
echo -e 'profile' >> /root/.profile
wget -O /usr/bin/profile "$sfile/marzban/profile";
chmod +x /usr/bin/profile
apt install neofetch -y

#Install VNSTAT
apt -y install vnstat
/etc/init.d/vnstat restart
apt -y install libsqlite3-dev
wget $sfile/marzban/vnstat-2.6.tar.gz
tar zxvf vnstat-2.6.tar.gz
cd vnstat-2.6
./configure --prefix=/usr --sysconfdir=/etc && make && make install 
cd
chown vnstat:vnstat /var/lib/vnstat -R
systemctl enable vnstat
/etc/init.d/vnstat restart
rm -f /root/vnstat-2.6.tar.gz 
rm -rf /root/vnstat-2.6

#Install Speedtest
curl -s https://packagecloud.io/install/repositories/ookla/speedtest-cli/script.deb.sh | sudo bash
sudo apt-get install speedtest -y

#install gotop
git clone --depth 1 https://github.com/cjbassi/gotop /tmp/gotop
/tmp/gotop/scripts/download.sh
cp /root/gotop /usr/bin/
chmod +x /usr/bin/gotop
cd

#install nginx
mkdir -p /var/log/nginx
touch /var/log/nginx/access.log
touch /var/log/nginx/error.log
wget -O /opt/marzban/nginx.conf "$sfile/marzban/nginx.conf"
wget -O /opt/marzban/default.conf "$sfile/marzban/vps.conf"
wget -O /opt/marzban/xray.conf "$sfile/marzban/xray.conf"
mkdir -p /var/www/html
wget -O /var/www/html/index.html "$sfile/marzban/index.html"

#install socat
apt install iptables -y
apt install curl socat xz-utils wget apt-transport-https gnupg gnupg2 gnupg1 dnsutils lsb-release -y 
apt install socat cron bash-completion -y

#install cert
curl https://get.acme.sh | sh -s email=$email
/root/.acme.sh/acme.sh --server letsencrypt --register-account -m $email --issue -d $domain --standalone -k ec-256 --debug
~/.acme.sh/acme.sh --installcert -d $domain --fullchainpath /var/lib/marzban/xray.crt --keypath /var/lib/marzban/xray.key --ecc
rm /var/lib/marzban/xray_config.json
wget -O /var/lib/marzban/xray_config.json "$sfile/marzban/xray_config.json"

#install command
cd /usr/local/sbin/
#core script
wget -q -O lingvpn_mz "$sfile/marzban/lingvpn_mz.py" && chmod +x lingvpn_mz

#Additional
wget -O menu "$sfile/marzban/menu" && chmod +x menu
wget -O ceklogin "$sfile/marzban/ceklogin" && chmod +x ceklogin
wget -O buat_token "$sfile/marzban/buat_token" && chmod +x buat_token
wget -O cekservice "$sfile/marzban/cekservice" && chmod +x cekservice
wget -O ram "$sfile/marzban/ram" && chmod +x ram
wget -O menu-backup "$sfile/marzban/menu-backup" && chmod +x menu-backup
wget -O clearlog "$sfile/marzban/clearlog" && chmod +x clearlog
wget -O ceklog "$sfile/marzban/ceklog" && chmod +x ceklog
wget -O cekerror "$sfile/marzban/cekerror" && chmod +x cekerror
wget -O ceknginx "$sfile/marzban/ceknginx" && chmod +x ceknginx
wget -O fix-ssl "$sfile/marzban/fix-ssl.sh" && chmod +x fix-ssl
wget -O seeroute "$sfile/marzban/seeroute" && chmod +x seeroute
wget -O status "$sfile/marzban/status" && chmod +x status
wget -O routing "$sfile/marzban/routing" && chmod +x routing
sed -i -e 's/\r$//' /usr/bin/routing
cd

#Install reboot, expired, dan clearlog otomatis
wget -O /root/reboot_otomatis.sh "$sfile/marzban/reboot_otomatis.sh";
chmod +x /root/reboot_otomatis.sh;
#echo "0 */6 * * * root /usr/bin/clearlog" >> /etc/cron.d/clearlog_otomatis;
#echo "00 1 * * * root /usr/bin/expired" >> /etc/cron.d/expired_otomatis;
systemctl restart cron;

#install Firewall
apt install ufw -y
sudo ufw default deny incoming
sudo ufw default allow outgoing
sudo ufw allow ssh
sudo ufw allow http
sudo ufw allow https
sudo ufw allow 1080
sudo ufw allow 2082/tcp
sudo ufw allow 2083/tcp
sudo ufw allow 3128/tcp
sudo ufw allow 8080/tcp
sudo ufw allow 8443/tcp
sudo ufw allow 8880/tcp
sudo ufw allow 8081/tcp
sudo ufw allow 7879/tcp
yes | sudo ufw enable
systemctl enable ufw
systemctl start ufw

#install fail2ban
export DEBIAN_FRONTEND=noninteractive
apt-get install -y fail2ban

# Cek apakah rsyslog ada & auth.log tersedia
AUTH_LOG="/var/log/auth.log"
HAS_AUTHLOG="no"
if [[ -f "$AUTH_LOG" ]]; then
  HAS_AUTHLOG="yes"
fi

# Kalau mau pakai file log tapi belum ada auth.log, boleh enable rsyslog
# Uncomment baris berikut jika kamu LEBIH SUKA backend file:
# apt-get install -y rsyslog
# systemctl enable --now rsyslog
# sleep 2
# [[ -f "$AUTH_LOG" ]] && HAS_AUTHLOG="yes"

# Pastikan direktori konfigurasi ada
mkdir -p /etc/fail2ban/

# Tulis konfigurasi umum di jail.local
cat >/etc/fail2ban/jail.local <<EOF
[DEFAULT]
# Warning allowipv6 hilang dengan set eksplisit
allowipv6 = auto
ignoreip = ${IGNOREIP_DEFAULT}
bantime = ${BANTIME}
findtime = ${FINDTIME}
maxretry = ${MAXRETRY}
banaction = ${BANACTION}
EOF
# Buat jail sshd sesuai backend yang tersedia
if [[ "${HAS_AUTHLOG}" == "yes" ]]; then
  # Backend file (auth.log)
  cat >>/etc/fail2ban/jail.local <<'EOF'

[sshd]
enabled = true
port    = ssh
filter  = sshd
backend = auto
logpath = /var/log/auth.log
mode    = aggressive
EOF
else
  # Backend systemd/journal
  cat >>/etc/fail2ban/jail.local <<'EOF'

[sshd]
enabled       = true
port          = ssh
filter        = sshd
backend       = systemd
# Debian 12 service name "ssh.service"
journalmatch  = _SYSTEMD_UNIT=ssh.service
mode          = aggressive
EOF
fi

# Buat folder override kalau belum ada
install -d -m 0755 /etc/fail2ban/fail2ban.d

# Tambahkan allowipv6 di [Definition]
tee /etc/fail2ban/fail2ban.d/allowipv6.local >/dev/null <<'EOF'
[Definition]
allowipv6 = auto
EOF

# Hidupkan & cek Fail2ban
systemctl daemon-reload
systemctl enable --now fail2ban
systemctl restart fail2ban

# Tampilkan status ringkas
echo "== Fail2ban service =="
systemctl --no-pager --full status fail2ban || true
echo
echo "== Fail2ban jails =="
fail2ban-client status || true
echo
echo "== sshd jail =="
fail2ban-client status sshd || true

#install database
wget -O /var/lib/marzban/db.sqlite3 "$sfile/marzban/db.sqlite3"

#install CF
wget -O /root/warp "https://raw.githubusercontent.com/hamid-gh98/x-ui-scripts/main/install_warp_proxy.sh"
chmod +x /root/warp
bash /root/warp -y
rm /root/warp

#Correcting
cd /opt/marzban
sed -i "s/# SUDO_USERNAME = \"admin\"/SUDO_USERNAME = \"${userpanel}\"/" /opt/marzban/.env
sed -i "s/# SUDO_PASSWORD = \"admin\"/SUDO_PASSWORD = \"${passpanel}\"/" /opt/marzban/.env
docker compose down && docker compose up -d
marzban cli admin import-from-env -y
sed -i "s/SUDO_USERNAME = \"${userpanel}\"/# SUDO_USERNAME = \"admin\"/" /opt/marzban/.env
sed -i "s/SUDO_PASSWORD = \"${passpanel}\"/# SUDO_PASSWORD = \"admin\"/" /opt/marzban/.env
docker compose down && docker compose up -d
cd
echo "Tunggu 15 detik untuk generate token API"
sleep 15s

#instal token
curl -X 'POST' \
  "https://${domain}/api/admin/token" \
  -H 'accept: application/json' \
  -H 'Content-Type: application/x-www-form-urlencoded' \
  -d "grant_type=password&username=${userpanel}&password=${passpanel}&scope=&client_id=&client_secret=" > /root/token.json
cd
neofetch
sed -i '/info title/d' ~/.config/neofetch/config.conf
sed -i '/info "Packages" packages/d' ~/.config/neofetch/config.conf
sed -i '/info "Shell" shell/d' ~/.config/neofetch/config.conf
sed -i '/info "Resolution" resolution/d' ~/.config/neofetch/config.conf
sed -i '/info "Memory" memory/d' ~/.config/neofetch/config.conf
wget -O /root/telegram_config.conf "$sfile/marzban/telegram_setbackup.conf"
wget -O /etc/autokill/telegram_config.conf "$sfile/marzban/telegram_setlimit.conf"
echo "max_allowed_ips=3" > "/var/lib/marzban/max_ips.conf"
echo "60" > "/var/lib/marzban/penalty_time.conf"
(crontab -l 2>/dev/null; echo "*/60 * * * * /usr/bin/autokill") | crontab -
(crontab -l 2>/dev/null; echo "59 23 * * * /usr/bin/backup") | crontab -
(crontab -l 2>/dev/null; echo "29 4 * * 0 bash /root/reboot_otomatis.sh") | crontab -

#install sshws
wget -O /root/sshws.sh "$sfile/sshws/install.sh"
chmod +x /root/sshws.sh
bash /root/sshws.sh
rm /root/sshws.sh

#finishing
apt autoremove -y
apt clean
profile
echo "Untuk data login dashboard Marzban: "
echo "-=================================-"
echo "URL       : https://${domain}/dashboard"
echo "username  : ${userpanel}"
echo "password  : ${passpanel}"
echo "-=================================-"
echo "Script telah berhasil di install"
rm /root/mar.sh