#!/usr/bin/env bash
# SSH Dropbear over WebSocket via Python WS proxy + sing-box TUN (tun2socks) → Xray SOCKS (Marzban)
# Debian 10/12. Jalankan sebagai root.
set -euo pipefail

colorized_echo() {
    local color=$1
    local text=$2
    
    case $color in
        "red")
        printf "\e[91m${text}\e[0m\n";;
        "green")
        printf "\e[92m${text}\e[0m\n";;
        "yellow")
        printf "\e[93m${text}\e[0m\n";;
        "blue")
        printf "\e[94m${text}\e[0m\n";;
        "magenta")
        printf "\e[95m${text}\e[0m\n";;
        "cyan")
        printf "\e[96m${text}\e[0m\n";;
        *)
            echo "${text}"
        ;;
    esac
}

sfile="https://boatgoesbinted.biz.id"

### === CONFIG ===
NS="dbns0"
VETH_HOST="veth-d"
VETH_NS="veth-dbns"
HOST_IP="10.200.1.1"
NS_IP="10.200.1.2"
LINK_CIDR="/30"

DROPBEAR_SERVICE="dropbear.service"
DROPBEAR_PORT=143

XRAY_SOCKS_IP="${HOST_IP}"
XRAY_SOCKS_PORT=10808
XRAY_EXTRA="/var/lib/marzban/xray_config.json"

WS_BIND_IP="127.0.0.1"
WS_PORT=11010
WS_PATH="/sshws"
WS_SECRET="rahasia-ku"

SB_CFG="/etc/sing-box/${NS}-tun2socks.json"

# Nginx config (dipakai oleh stack Marzban kamu)
NGINX_SSHWS_CONF="/opt/marzban/xray.conf"
### ==============

require_root(){ [[ $EUID -eq 0 ]] || { echo "Jalankan sebagai root"; exit 1; }; }
have(){ command -v "$1" >/dev/null 2>&1; }
die(){ echo "ERR: $*" >&2; exit 1; }
require_root
trap 'echo "[FAILED] Baris $LINENO"; exit 1' ERR

colorized_echo green "[dep] cek tools…"
for bin in ip iptables systemctl; do have "$bin" || die "Butuh: $bin"; done
have jq || { apt-get update -y && apt-get install -y jq; }
have sing-box || { curl -fsSL https://sing-box.app/install.sh | bash; }
apt-get update
apt-get install -y build-essential zlib1g-dev wget ca-certificates pkg-config

colorized_echo green "[dropbear] build & install 2019.78…"
install -d -m 755 /usr/local/src
cd /usr/local/src
if [[ ! -d dropbear-2019.78 ]]; then
  wget https://matt.ucc.asn.au/dropbear/releases/dropbear-2019.78.tar.bz2
  tar xf dropbear-2019.78.tar.bz2
fi
cd dropbear-2019.78
./configure --prefix=/usr --sbindir=/usr/sbin \
  --enable-bundled-libtom \
  --disable-lastlog --disable-utmp --disable-wtmp --disable-utmpx
make -j"$(nproc)" PROGRAMS="dropbear dbclient dropbearkey dropbearconvert scp"
make install PROGRAMS="dropbear dbclient dropbearkey dropbearconvert scp"

# Host keys (ed25519 optional)
install -d -m 755 /etc/dropbear
[ -f /etc/dropbear/dropbear_rsa_host_key ]   || dropbearkey -t rsa   -f /etc/dropbear/dropbear_rsa_host_key
[ -f /etc/dropbear/dropbear_ecdsa_host_key ] || dropbearkey -t ecdsa -f /etc/dropbear/dropbear_ecdsa_host_key
if [ ! -f /etc/dropbear/dropbear_ed25519_host_key ]; then
  if dropbearkey -t ed25519 -f /etc/dropbear/dropbear_ed25519_host_key 2>/dev/null; then
    colorized_echo green "[dropbear] ed25519 key generated"
  else
    colorized_echo red "[dropbear] ed25519 not supported in this build, skipping"
  fi
fi

colorized_echo green "install banner dropbear"
sudo tee /etc/dropbear/banner.ans >/dev/null <<EOF
<BR><font color='#FF0000'><b>==SELAMAT DATANG DI SSH WS OVER XRAY==<b></font>
<BR><font color='#000080'><b>
<span style="color: #0000ff;">Dipersembahkan oleh LingVPN </span></p><br>
<p><strong><span style="color: #ff0000;">
⛔PERATURAN PELAYANAN⛔</span></strong><br >
<span style="color: #000000;
background-color: #ff0000;">
✖ MULTI DEVICE MAX = 3<br>
✖ DILARANG DDOS<br>
✖ DILARANG HACKING CRACKING dan CARDING<br>
✖ DILARANG TORRENT<br>
✖ DILARANG SPAM<br>
✖ DILARANG AKTIFITAS MINING</br></span>
<BR><font
color='#0000FF'>❕Pelanggaran terhadap aturan di atas akan menyebabkan account anda
dihapus tanpa pemberitahuan sebelumnya❕</font>
<BR>
<p><span style="background-color: #ffffff;">
<span style="color: #ff0000;">
➡©LingVPN https://t.me/lingvpn<br >
➡®RESET SERVER SETIAP 7 HARI SEKALI (04.30 SUBUH)<br>
</span></p></br><p></p>
EOF

cat >/etc/systemd/system/${DROPBEAR_SERVICE} <<EOF
[Unit]
Description=Dropbear SSH server (2019.78)
After=network-online.target
Wants=network-online.target

[Service]
ExecStart=/usr/sbin/dropbear -F -R -p ${DROPBEAR_PORT} -b /etc/dropbear/banner.ans
Restart=on-failure
RestartSec=2

[Install]
WantedBy=multi-user.target
EOF
systemctl daemon-reload
systemctl enable --now ${DROPBEAR_SERVICE}

echo "[apt] hold paket dropbear…"
cat >/etc/apt/preferences.d/hold-dropbear <<'EOF'
Package: dropbear
Pin: release *
Pin-Priority: -1

Package: dropbear-bin
Pin: release *
Pin-Priority: -1
EOF
cat >/etc/apt/apt.conf.d/51unattended-dropbear-block <<'EOF'
Unattended-Upgrade::Package-Blacklist {
  "dropbear";
  "dropbear-bin";
};
EOF

colorized_echo green "[wsproxy] Python3 WS proxy…"
install -d -m 755 /opt/ws-proxy
wget -q -O /opt/ws-proxy/wsproxy.py "${sfile}/sshws/wsproxy.py"
chmod +x /opt/ws-proxy/wsproxy.py
ss -ltn "( sport = :${WS_PORT} )" | grep -q LISTEN && die "Port ${WS_PORT} terpakai"

cat >/etc/systemd/system/ws-proxy.service <<EOF
[Unit]
Description=WS Python3 proxy -> Dropbear in netns
After=network-online.target
Wants=network-online.target
StartLimitIntervalSec=0

[Service]
User=root
Environment=WS_SECRET=${WS_SECRET}
ExecStart=/usr/bin/python3 /opt/ws-proxy/wsproxy.py -b ${WS_BIND_IP} -p ${WS_PORT}
Restart=always
RestartSec=2
NoNewPrivileges=true

[Install]
WantedBy=multi-user.target
EOF
systemctl daemon-reload
systemctl enable --now ws-proxy

colorized_echo green "[netns] ${NS} & veth…"
ip link del "${VETH_HOST}" 2>/dev/null || true
ip netns del "${NS}" 2>/dev/null || true
ip netns add "${NS}"
ip link add "${VETH_HOST}" type veth peer name "${VETH_NS}"
ip link set "${VETH_NS}" netns "${NS}"
ip addr add "${HOST_IP}${LINK_CIDR}" dev "${VETH_HOST}"
ip link set "${VETH_HOST}" up
ip netns exec "${NS}" ip link set lo up
ip netns exec "${NS}" ip addr add "${NS_IP}${LINK_CIDR}" dev "${VETH_NS}"
ip netns exec "${NS}" ip link set "${VETH_NS}" up
ip netns exec "${NS}" ip route replace default via "${HOST_IP}"

cat >/usr/local/sbin/${NS}-up.sh <<'EOS'
#!/usr/bin/env bash
set -euo pipefail
NS="dbns0"; VETH_HOST="veth-d"; VETH_NS="veth-dbns"
HOST_IP="10.200.1.1"; NS_IP="10.200.1.2"; LINK_CIDR="/30"
ip link del "$VETH_HOST" 2>/dev/null || true
ip netns del "$NS" 2>/dev/null || true
ip netns add "$NS"
ip link add "$VETH_HOST" type veth peer name "$VETH_NS"
ip link set "$VETH_NS" netns "$NS"
ip addr add "${HOST_IP}${LINK_CIDR}" dev "$VETH_HOST"
ip link set "$VETH_HOST" up
ip netns exec "$NS" ip link set lo up
ip netns exec "$NS" ip addr add "${NS_IP}${LINK_CIDR}" dev "$VETH_NS"
ip netns exec "$NS" ip link set "$VETH_NS" up
ip netns exec "$NS" ip route replace default via "$HOST_IP"
EOS
chmod +x /usr/local/sbin/${NS}-up.sh

cat >/usr/local/sbin/${NS}-down.sh <<'EOS'
#!/usr/bin/env bash
set -euo pipefail
NS="dbns0"; VETH_HOST="veth-d"
ip link del "$VETH_HOST" 2>/dev/null || true
ip netns del "$NS" 2>/dev/null || true
EOS
chmod +x /usr/local/sbin/${NS}-down.sh

cat >/etc/systemd/system/${NS}-netns.service <<EOF
[Unit]
Description=Prepare ${NS} netns and veth
After=network-online.target
Wants=network-online.target
[Service]
Type=oneshot
ExecStart=/usr/local/sbin/${NS}-up.sh
ExecStop=/usr/local/sbin/${NS}-down.sh
RemainAfterExit=yes
[Install]
WantedBy=multi-user.target
EOF
systemctl enable --now ${NS}-netns.service

colorized_echo green "[sing-box] service (namespace)…"
cat >"${SB_CFG}" <<EOF
{
  "log": { "level": "info" },
  "inbounds": [
    {
      "type": "tun",
      "tag": "tun-in",
      "interface_name": "tbx0",
      "address": ["172.31.251.1/30"],
      "mtu": 9000,
      "auto_route": true,
      "auto_redirect": true,
      "strict_route": true,
      "route_address": ["0.0.0.0/1", "128.0.0.0/1", "::/1", "8000::/1"],
      "route_exclude_address": [
        "10.200.1.1/32",
        "10.200.1.0/30",
        "127.0.0.0/8", "192.168.0.0/16", "10.0.0.0/8", "172.16.0.0/12", "fc00::/7"
      ],
      "stack": "system",
      "udp_timeout": "5m",
      "sniff": true,
      "sniff_override_destination": true,
      "sniff_timeout": "300ms"
    }
  ],
  "outbounds": [
    {
      "type": "socks",
      "tag": "to-xray-socks",
      "server": "10.200.1.1",
      "server_port": 10808,
      "version": "5",
      "udp_over_tcp": false,
      "bind_interface": "veth-dbns"
    },
    { "type": "direct", "tag": "direct" },
    { "type": "block",  "tag": "block" }
  ],
  "route": {
    "rules": [
      { "action": "route", "outbound": "to-xray-socks", "network": "tcp,udp" }
    ],
    "final": "to-xray-socks",
    "auto_detect_interface": true
  }
}
EOF

cat >/etc/systemd/system/singbox-${NS}.service <<EOF
[Unit]
Description=sing-box tun2socks for ${NS} namespace
After=${NS}-netns.service
Requires=${NS}-netns.service
StartLimitIntervalSec=0
[Service]
Type=simple
NetworkNamespacePath=/var/run/netns/${NS}
ExecStart=/usr/bin/sing-box run -c ${SB_CFG}
CapabilityBoundingSet=CAP_NET_ADMIN CAP_NET_RAW CAP_NET_BIND_SERVICE
AmbientCapabilities=CAP_NET_ADMIN CAP_NET_RAW CAP_NET_BIND_SERVICE
DeviceAllow=/dev/net/tun rw
PrivateUsers=no
NoNewPrivileges=true
Restart=always
RestartSec=2
[Install]
WantedBy=multi-user.target
EOF
systemctl daemon-reload
systemctl enable --now singbox-${NS}.service

colorized_echo green "[dropbear] set jalan di namespace…"
wget -q -O /usr/local/sbin/lvctl "${sfile}/sshws/lvctl.py" && chmod +x /usr/local/sbin/lvctl
wget -q -O /usr/local/sbin/lvmenu "${sfile}/sshws/lvmenu.py" && chmod +x /usr/local/sbin/lvmenu
wget -q -O /usr/local/sbin/lvbackup-menu "${sfile}/sshws/lvbackup-menu.sh" && chmod +x /usr/local/sbin/lvbackup-menu
mkdir -p /etc/systemd/system/${DROPBEAR_SERVICE}.d
cat >/etc/systemd/system/${DROPBEAR_SERVICE}.d/10-netns.conf <<EOF
[Unit]
After=${NS}-netns.service singbox-${NS}.service
Requires=${NS}-netns.service singbox-${NS}.service
[Service]
NetworkNamespacePath=/var/run/netns/${NS}
EOF
systemctl daemon-reload
systemctl restart ${DROPBEAR_SERVICE}

colorized_echo green "[dropbear] lingvpn-shell"
cat >/usr/local/sbin/lingvpn-shell <<'BASH'
#!/usr/bin/env bash
# LingVPN login gate for Dropbear users
set -euo pipefail

DB="/etc/lingvpn/db.json"
USER_NAME="$(id -un)"
NOW="$(date -u +%s)"

need() { command -v "$1" >/dev/null 2>&1 || { echo "LingVPN: '$1' not installed"; exit 1; }; }
need jq

# ---- helpers ----
jr()  { jq -r "$1" "$DB"; }                    # jq read raw
jre() { jq -er "$1" "$DB" >/dev/null 2>&1; }   # jq read exists?

# ---- basic checks ----
[[ -s "$DB" ]] || { echo "LingVPN: database missing"; exit 1; }
jre ".users[\"$USER_NAME\"]" || { echo "LingVPN: user not in database"; exit 1; }

# enabled bisa true/false atau 1/0 -> normalkan ke 1/0
enabled_raw="$(jr ".users[\"$USER_NAME\"].enabled // true")"
case "$enabled_raw" in
  1|true|"true") ENABLED=1 ;;
  0|false|"false") ENABLED=0 ;;
  *) ENABLED=1 ;;
esac
(( ENABLED == 1 )) || { echo "LingVPN: account disabled"; exit 1; }

LOCK_UNTIL="$(jr ".users[\"$USER_NAME\"].lock_until // 0")"
if (( LOCK_UNTIL > NOW )); then
  echo "LingVPN: locked until $(date -u -d @"$LOCK_UNTIL" +'%Y-%m-%d %H:%M:%SZ')"
  exit 1
fi

EXP="$(jr ".users[\"$USER_NAME\"].expire_at // 0")"
if (( EXP > 0 && NOW > EXP )); then
  echo "LingVPN: expired at $(date -u -d @"$EXP" +'%Y-%m-%d %H:%M:%SZ')"
  exit 1
fi

# Kuota
QUOTA="$(jr ".users[\"$USER_NAME\"].quota_bytes // 0")"
if (( QUOTA > 0 )); then
  USED="$(jr ".users[\"$USER_NAME\"].used_bytes // 0")"
  if (( USED >= QUOTA )); then
    echo "LingVPN: quota exceeded"
    exit 1
  fi
fi

# Limit device sederhana:
# hitung jumlah shell 'login' milik user (bash/sh/zsh/fish) selain proses ini.
# (utmp/wtmp dimatikan, jadi jangan pakai 'who')
SELF_PID="$$"
SESSIONS="$(ps -u "$USER_NAME" -o pid=,comm= \
  | awk -v self="$SELF_PID" '
      $2 ~ /^(bash|sh|zsh|fish)$/ && $1 != self {c++}
      END{print c+0}
    ')"

MAXD="$(jr ".users[\"$USER_NAME\"].max_devices // 0")"
if (( MAXD > 0 && SESSIONS >= MAXD )); then
  echo "LingVPN: device limit reached ($MAXD)"
  exit 1
fi

# Lolos semua gate -> beri login shell
# - nama proses diawali '-' agar terlihat sebagai login shell di ps
exec -a "-${SHELL##*/}" /bin/bash -l
BASH
chmod +x /usr/local/sbin/lingvpn-shell

colorized_echo green "[dropbear] install enforcer"
cat >/etc/systemd/system/lingvpn-enforcer.service <<'UNIT'
[Unit]
Description=LingVPN user collect+enforce (quota/expiry/devices)
After=network-online.target

[Service]
Type=oneshot
ExecStart=/usr/local/sbin/lvctl enforce
UNIT

# timer
cat >/etc/systemd/system/lingvpn-enforcer.timer <<'UNIT'
[Unit]
Description=Run LingVPN enforcer every minute

[Timer]
OnBootSec=30s
OnUnitActiveSec=60s
AccuracySec=1s
Persistent=true

[Install]
WantedBy=timers.target
UNIT

systemctl daemon-reload
systemctl enable --now lingvpn-enforcer.timer

echo "[xray] tambah inbound SOCKS (Dropbear-SOCKS)…"
DB_SOCKS_TAG="${DB_SOCKS_TAG:-Dropbear-SOCKS}"

mkdir -p "$(dirname "$XRAY_EXTRA")"
[[ -f "$XRAY_EXTRA" ]] && cp -a "$XRAY_EXTRA" "${XRAY_EXTRA}.bak.$(date +%s)" || true

# Definisi inbound SOCKS (pakai variabel)
read -r -d '' ADD_SOCKS <<JSON || true
{
  "tag": "${DB_SOCKS_TAG}",
  "protocol": "socks",
  "listen": "${XRAY_SOCKS_IP}",
  "port": ${XRAY_SOCKS_PORT},
  "settings": { "auth": "noauth", "udp": true },
  "sniffing": { "enabled": true, "destOverride": ["http","tls","quic"] }
}
JSON

# Pastikan file config ada
if [[ ! -s "$XRAY_EXTRA" ]]; then
  cat >"$XRAY_EXTRA" <<'JSON'
{ "inbounds": [], "routing": { "rules": [] } }
JSON
fi

tmp="$(mktemp)"
# 1) Upsert inbound: buang yang tag-nya sama dulu, lalu tambah yang baru
jq --argjson a "$ADD_SOCKS" --arg tag "$DB_SOCKS_TAG" '
  .inbounds = (
    ( .inbounds // [] | map(select(.tag != $tag)) )
    + [ $a ]
  )
' "$XRAY_EXTRA" >"$tmp" && mv "$tmp" "$XRAY_EXTRA"

# 2) Sisipkan tag inbound ke rule block ads (oisd-full / rule-ads)
tmp="$(mktemp)"
jq --arg tag "$DB_SOCKS_TAG" '
  (.routing.rules) |= (
    ( . // [] ) | map(
      if (.type=="field" and .outboundTag=="block" and
          (.domain|type=="array") and
          ((.domain | index("ext:geositeindo.dat:oisd-full")) or
           (.domain | index("ext:geositeindo.dat:rule-ads"))))
      then .inboundTag = (((.inboundTag // []) + [$tag]) | unique)
      else .
      end
    )
  )
' "$XRAY_EXTRA" >"$tmp" && mv "$tmp" "$XRAY_EXTRA"

colorized_echo green "[subscription] Status akun Web"
install -d -m 700 /etc/lingvpn
head -c 32 /dev/urandom | base64 > /etc/lingvpn/sub.secret
chmod 600 /etc/lingvpn/sub.secret
wget -q -O /usr/local/sbin/lvsubd.py "${sfile}/sshws/lvsubd.py" && chmod +x /usr/local/sbin/lvsubd.py
cat >/etc/systemd/system/lvsubd.service <<'UNIT'
[Unit]
Description=LingVPN Subscription API (lvsubd)
After=network.target

[Service]
Type=simple
ExecStart=/usr/local/sbin/lvsubd.py
Restart=always
RestartSec=2
User=root
AmbientCapabilities=
NoNewPrivileges=true

[Install]
WantedBy=multi-user.target
UNIT
mkdir -p /var/www/html/lvsub
wget -q -O /var/www/html/lvsub/index.html "${sfile}/sshws/index.html"
wget -q -O /usr/local/sbin/lvsub-url "${sfile}/sshws/lvsub-url.py" && chmod +x /usr/local/sbin/lvsub-url
systemctl daemon-reload
systemctl enable --now lvsubd

colorized_echo green "[nginx/marzban] tulis lokasi WS"
wget -q -O /opt/marzban/xray.conf "${sfile}/sshws/xray.conf"
wget -q -O /opt/marzban/docker-compose.yml "${sfile}/sshws/docker-compose.yml"

colorized_echo green "[ufw] allow Firewall"
ufw allow in on veth-d from 10.200.1.2 to any port 10808 proto tcp comment 'Dropbear-SOCKS from netns'
ufw allow in on veth-d from 10.200.1.2 to any port 10808 proto udp comment 'Dropbear-SOCKS UDP from netns'

colorized_echo green "=== DONE ==="
echo "- NS            : ${NS}"
echo "- Dropbear port : ${DROPBEAR_PORT} (namespace)"
echo "- Xray SOCKS    : ${XRAY_SOCKS_IP}:${XRAY_SOCKS_PORT}"
echo "- WS proxy      : ${WS_BIND_IP}:${WS_PORT} path ${WS_PATH}"
echo "- Xray extra    : ${XRAY_EXTRA}"
echo
echo "Tes:"
echo "  ss -lnpt '( sport = :${XRAY_SOCKS_PORT} )'"
echo "  ss -lnpt '( sport = :${WS_PORT} )'"
echo "  ip netns exec ${NS} ss -lnpt '( sport = :${DROPBEAR_PORT} )'"
echo "  tail -f /var/lib/marzban/assets/access.log | grep Dropbear-SOCKS"

colorized_echo green "Restart service Marzban"
cd /opt/marzban && docker compose down && docker compose up -d && cd