#!/usr/bin/env python3
import argparse, socket, threading, select, sys

LISTENING_ADDR = "127.0.0.1"
DEFAULT_HOST   = "10.200.1.2:143"   # << ganti jika perlu
PASS           = "rahasia-ku"       # kosongkan "" jika mau open

BUFLEN  = 16384
TIMEOUT = 60

RESP_101 = (
    "HTTP/1.1 101 Switching Protocols\r\n"
    "Upgrade: websocket\r\n"
    "Connection: Upgrade\r\n\r\n"
).encode()

RESP_403 = b"HTTP/1.1 403 Forbidden\r\nContent-Length:0\r\n\r\n"
RESP_400 = b"HTTP/1.1 400 Bad Request\r\nContent-Length:0\r\n\r\n"

def parse_headers(first_packet: bytes):
    try:
        header, _ = first_packet.split(b"\r\n\r\n", 1)
    except ValueError:
        return {}
    lines = header.split(b"\r\n")
    out = {}
    for ln in lines[1:]:
        if b":" in ln:
            k, v = ln.split(b":", 1)
            out[k.strip().lower()] = v.strip()
    return out

def find_hostport(hdrs: dict):
    v = hdrs.get(b"x-real-host")
    hostport = v.decode() if v else DEFAULT_HOST
    if ":" not in hostport:
        return hostport, 80
    h, p = hostport.rsplit(":", 1)
    try:
        return h, int(p)
    except:
        return h, 80

def pipe(src, dst, closer):
    try:
        while True:
            r, _, _ = select.select([src], [], [], TIMEOUT)
            if not r:
                break
            data = src.recv(BUFLEN)
            if not data:
                break
            dst.sendall(data)
    except:
        pass
    finally:
        closer()

def handle_client(cli_sock, cli_addr):
    try:
        first = cli_sock.recv(BUFLEN)
        if not first:
            cli_sock.close(); return

        # Minimal cek Upgrade
        if b"upgrade: websocket" not in first.lower():
            cli_sock.sendall(RESP_400); cli_sock.close(); return

        hdrs = parse_headers(first)

        # Auth by X-Pass (if PASS set)
        if PASS:
            if hdrs.get(b"x-pass", b"").decode() != PASS:
                cli_sock.sendall(RESP_403); cli_sock.close(); return

        host, port = find_hostport(hdrs)

        # Connect target
        tgt = socket.create_connection((host, port), timeout=10)

        # Kirim 101
        cli_sock.sendall(RESP_101)

        # Relay dua arah
        def shutdown_all():
            for s in (cli_sock, tgt):
                try:
                    s.shutdown(socket.SHUT_RDWR)
                except:
                    pass
                try:
                    s.close()
                except:
                    pass

        t1 = threading.Thread(target=pipe, args=(cli_sock, tgt, shutdown_all), daemon=True)
        t2 = threading.Thread(target=pipe, args=(tgt, cli_sock, shutdown_all), daemon=True)
        t1.start(); t2.start(); t1.join(); t2.join()

    except Exception as e:
        try:
            cli_sock.close()
        except:
            pass

def main():
    ap = argparse.ArgumentParser()
    ap.add_argument("-b", "--bind", default=LISTENING_ADDR)
    ap.add_argument("-p", "--port", type=int, required=True)
    args = ap.parse_args()

    srv = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    srv.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    srv.bind((args.bind, args.port))
    srv.listen(128)

    try:
        while True:
            c, a = srv.accept()
            threading.Thread(target=handle_client, args=(c, a), daemon=True).start()
    except KeyboardInterrupt:
        pass
    finally:
        srv.close()

if __name__ == "__main__":
    main()
