<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Models\VpsCategory;
use Illuminate\Validation\Rule;

class VpsCategoryController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = VpsCategory::query();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($row) {
                    $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Edit" class="btn btn-primary btn-xs editData"><i class="fa fa-edit"></i></a>';
                    $btn = $btn . ' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-original-title="Delete" class="btn btn-danger btn-xs deleteData"><i class="fa fa-trash"></i></a>';
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('admin.vps_category');
    }

    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'name' => [
                'required',
                Rule::unique('vps_categories')->ignore($request->id),
            ],
            'seq' => 'required',
        ]);

        VpsCategory::updateOrCreate(
            [
                'id' => $request->id
            ],
            [
                'name' => $request->name,
                'seq' => $request->seq,
            ]
        );

        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function show($id): JsonResponse
    {
        $data = VpsCategory::find($id);

        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => $data,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function destroy(Request $request): JsonResponse
    {
        $request->validate([
            'id' => 'required|integer|exists:vps_categories,id',
        ]);
        $updated = VpsCategory::find($request->id)?->delete();
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $updated ? 200 : 404,
                'message' => $updated ? 'OK' : 'Record not found or already inactive',
            ]
        ], $updated ? 200 : 404);
    }

    public function select2(Request $request)
    {
        $query = $request->get('q');
        $limit = 10;

        $data = VpsCategory::where('name', 'LIKE', "%$query%")
            ->orderBy('seq', 'asc')
            ->paginate($limit);

        $results = $data->map(function ($item) {
            return [
                'id' => $item->id,
                'text' => $item->name,
            ];
        });

        return response()->json([
            'data' => $results,
            'next_page_url' => $data->nextPageUrl(),
        ]);
    }
}
