<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Models\VpsProxies;
use Illuminate\Validation\Rule;

class VpsProxiesController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = VpsProxies::query();
            if ($request->showDeleted == 1) {
                $data = $data->onlyTrashed();
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($row) {
                    if ($row->trashed()) {
                        $btn = '<a href="javascript:void(0)" data-toggle="tooltip" data-id="' . $row->id . '" data-name="' . $row->name . '" data-original-title="Restore" class="btn btn-info btn-xs restoreData"><i class="fa fa-sync"></i></a>';
                    } else {
                        $btn = '<a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-name="' . $row->name . '" data-original-title="Edit" class="btn btn-primary btn-xs editData"><i class="fa fa-edit"></i></a>';
                        $btn = $btn . ' <a href="javascript:void(0)" data-toggle="tooltip"  data-id="' . $row->id . '" data-name="' . $row->name . '" data-original-title="Delete" class="btn btn-danger btn-xs deleteData"><i class="fa fa-trash"></i></a>';
                    }
                    return $btn;
                })
                ->rawColumns(['action'])
                ->make(true);
        }

        return view('admin.vps_proxies');
    }

    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'name' => [
                'required',
                Rule::unique('vps_proxies')->ignore($request->id),
            ],
            'seq' => 'required',
        ]);

        VpsProxies::updateOrCreate(
            [
                'id' => $request->id
            ],
            [
                'name' => $request->name,
                'seq' => $request->seq,
            ]
        );

        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function show($id): JsonResponse
    {
        $data = VpsProxies::find($id);

        $code = 200;
        $message = 'OK';
        return response()->json([
            'response' => $data,
            'metadata' => [
                'code' => $code,
                'message' => $message
            ]
        ], $code);
    }

    public function restore($id): JsonResponse
    {
        $restored = VpsProxies::onlyTrashed()->find($id)?->restore();
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $restored ? 200 : 404,
                'message' => $restored ? 'OK' : 'Record not found or already deleted',
            ]
        ], $restored ? 200 : 404);
    }

    public function destroy($id): JsonResponse
    {
        $deleted = VpsProxies::find($id)?->delete();
        return response()->json([
            'response' => null,
            'metadata' => [
                'code' => $deleted ? 200 : 404,
                'message' => $deleted ? 'OK' : 'Record not found or already inactive',
            ]
        ], $deleted ? 200 : 404);
    }

    public function select2(Request $request)
    {
        $query = $request->get('q');
        $limit = 10;

        $data = VpsProxies::where('name', 'LIKE', "%$query%")
            ->orderBy('seq', 'asc')
            ->paginate($limit);

        $results = $data->map(function ($item) {
            return [
                'id' => $item->id,
                'text' => $item->name,
            ];
        });

        return response()->json([
            'data' => $results,
            'next_page_url' => $data->nextPageUrl(),
        ]);
    }
}
