<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\User;
use App\Models\Invoice;
use App\Models\VpsDetail;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\VpsSubscription;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Admin\TripayController;
use App\Http\Controllers\Admin\MarzbanController;

class ApiController extends Controller
{
    public function cronjobCost()
    {
        $now = Carbon::now('Asia/Jakarta');
        $oneHourAgo = $now->copy()->subHour();
        $vps_subscription = VpsSubscription::where('pay_at', '<=', $oneHourAgo)
            ->get();
        if ($vps_subscription->isEmpty()) {
            return response()->json([
                'metadata' => [
                    'code' => 404,
                    'message' => 'user subscription used 1 hour not found',
                ]
            ], 404);
        }
        foreach ($vps_subscription as $item) {
            $payAt = Carbon::parse($item->pay_at);
            $minutesDiff = $payAt->diffInMinutes($now);
            $fullHours = floor($minutesDiff / 60);
            if ($fullHours > 0) {
                $user = User::find($item->user_id);
                if (!$user) {
                    continue;
                }
                $vps_detail = VpsDetail::find($item->vps_details_id);
                if (!$vps_detail) {
                    continue;
                }
                $priceHour = $vps_detail->price_hour;
                $totalCost = $priceHour * $fullHours;
                if ($user->amount >= $totalCost) {
                    if ($user->amount != $totalCost) {
                        $new_balance = $user->amount - $totalCost;
                        Invoice::create([
                            'user_id' => $user->id,
                            'vps_details_id' => $vps_detail->id,
                            'uuid' => (string) Str::uuid(),
                            'price' => str_replace(',', '', $totalCost),
                            'initial_balance' => str_replace(',', '', $user->amount),
                            'new_balance' => str_replace(',', '', $new_balance),
                        ]);
                    }
                    $user->amount -= $totalCost;
                    $user->save();
                    $item->balance += $totalCost;
                    $item->suspend = 0;
                    $requestMarzban = new Request([
                        'id' => $vps_detail->vps_id,
                        'username' => $item->username,
                        'status' => 'active',
                    ]);
                    $marzbanController = new MarzbanController();
                    $marzbanController->usersStatus($requestMarzban);
                } else {
                    $item->suspend = 1;
                    $requestMarzban = new Request([
                        'id' => $vps_detail->vps_id,
                        'username' => $item->username,
                        'status' => 'disabled',
                    ]);
                    $marzbanController = new MarzbanController();
                    $marzbanController->usersStatus($requestMarzban);
                }
                $item->pay_at = $payAt->addHours($fullHours);
                $item->save();
            }
        }
        return response()->json([
            'metadata' => [
                'code' => 200,
                'message' => 'Success',
            ]
        ], 200);
    }

    public function callback(Request $request)
    {
        $tripayController = new TripayController();
        return $tripayController->callback($request);
    }
}
