<?php

namespace App\Http\Controllers\Member;

use App\Models\Information;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Yajra\DataTables\DataTables;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Models\VpsCategory;
use App\Models\VpsCountry;
use App\Models\VpsProxies;

class MemberInformationController extends Controller
{
    public function index(Request $request)
    {
        $vps_category = VpsCategory::orderBy('seq', 'asc')->get();
        $vps_country = VpsCountry::orderBy('seq', 'asc')->get();
        $vps_proxies = VpsProxies::orderBy('seq', 'asc')->get();
        $information = Information::where('expires_at', '>', Carbon::now('Asia/Jakarta'))
            ->get();

        return view('member.information', compact('information', 'vps_category', 'vps_country', 'vps_proxies'));
    }
}
