<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, ...$roles): Response
    {
        if (!Auth::check()) {
            return redirect()->route('login');
        }
        $userRole = Auth::user()->role;
        if (!in_array($userRole, $roles)) {
            switch ($userRole) {
                case 'admin':
                    return redirect()->route('admin.index');
                case 'member':
                    return redirect()->route('member.index');
                default:
                    return redirect()->route('index');
            }
        }

        return $next($request);
    }
}
