<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Information extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'informations';

    protected $fillable = [
        'category',
        'name',
        'description',
        'is_product',
        'is_pricing',
        'is_blog',
        'is_billing',
        'is_info',
        'start_at',
        'expires_at',
    ];

    protected $dates = [
        'start_at',
        'expires_at',
    ];
}
