@extends('layouts.admin')
@section('css')
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Billing</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Billing</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="card">
                <div class="card-body">
                    <div class="d-grid gap-2 d-md-flex mb-3">
                        <div class="row">
                            <div class="col-12 col-sm-3">
                                <div class="form-group">
                                    <label for="filterDate1">Start</label>
                                    <input type="date" class="form-control" id="filterDate1"
                                        value="{{ date('Y-m-01') }}">
                                </div>
                            </div>
                            <div class="col-12 col-sm-3">
                                <div class="form-group">
                                    <label for="filterDate2">End</label>
                                    <input type="date" class="form-control" id="filterDate2" value="{{ date('Y-m-d') }}">
                                </div>
                            </div>
                            <div class="col-12 col-sm-3">
                                <div class="form-group">
                                    <label for="filterStatus">Status</label>
                                    <select class="form-control" id="filterStatus">
                                        <option value="ALL">ALL</option>
                                        <option value="UNPAID">UNPAID</option>
                                        <option value="PAID">PAID</option>
                                        <option value="REFUND">REFUND</option>
                                        <option value="EXPIRED">EXPIRED</option>
                                        <option value="FAILED">FAILED</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-12 col-sm-3">
                                <div class="form-group">
                                    <label for="filterData">&nbsp;</label>
                                    <a class="btn btn-success form-control" href="javascript:void(0)" id="filterData"> <i
                                            class="fa fa-search"></i> Filter</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover text-nowrap data-table w-100" id="table1">
                            <thead>
                                <tr>
                                    <th class="text-center">No</th>
                                    <th class="text-center">Request Date</th>
                                    <th class="text-center">Payment Type</th>
                                    <th class="text-center">Discount</th>
                                    <th class="text-center">Amount</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <div class="modal fade" id="formModal1" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="formModalHeading1"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="dataForm1" name="dataForm1" class="form-horizontal">
                        <input type="hidden" name="id" id="id">
                        @csrf
                        <div class="alert alert-danger print-error-msg" style="display:none">
                            <ul></ul>
                        </div>

                        <div class="form-group">
                            <label for="name" class="col-sm-2 control-label">Name</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="name" name="name"
                                    placeholder="Enter Name">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="code" class="col-sm-2 control-label">Code</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="code" name="code"
                                    placeholder="Enter Code">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="quota" class="col-sm-2 control-label">Quota</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control quota" id="quota" name="quota"
                                    placeholder="Enter Quota">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="amount" class="col-sm-2 control-label">Amount</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control price" id="amount" name="amount"
                                    placeholder="Enter Amount">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="expires_at" class="col-sm-2 control-label">Expired</label>
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="col-6">
                                        <input type="date" class="form-control" id="expires_at" name="expires_at"
                                            placeholder="Enter Expired" value="{{ date('Y-m-d') }}">
                                    </div>
                                    <div class="col-6">
                                        <input type="time" class="form-control" id="expires_at_time"
                                            name="expires_at_time" placeholder="Enter Expired"
                                            value="{{ date('H:i') }}">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-offset-2 col-sm-10">
                            <button type="submit" class="btn btn-success mt-2" id="saveBtn">Submit</button>
                            <button type="button" class="btn btn-danger mt-2" id="cancelBtn" data-dismiss="modal"><i
                                    class="fa fa-cancel"></i>
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(function() {
            var table = $('#table1').DataTable({
                responsive: true,
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('admin.billing') }}",
                    data: function(d) {
                        d.date1 = $('#filterDate1').val();
                        d.date2 = $('#filterDate2').val();
                        d.status = $('#filterStatus').val();
                    }
                },
                order: [
                    [1, 'desc']
                ],
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false,
                        className: 'text-center'
                    },
                    {
                        data: 'created_at',
                        name: 'created_at',
                        className: 'text-center'
                    },
                    {
                        data: 'payment_name',
                        name: 'payment_name',
                        className: 'text-center'
                    },
                    {
                        data: 'discount_amount',
                        name: 'discount_amount',
                        className: 'text-right',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    },
                    {
                        data: 'amount',
                        name: 'amount',
                        className: 'text-right',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    },
                    {
                        data: 'status',
                        name: 'status',
                        className: 'text-center'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false,
                        className: 'text-center'
                    },
                ]
            });

            $('#filterData').click(function() {
                table.draw();
            });

            $('#createData').click(function() {
                $('#id').val('');
                $('#dataForm1').trigger("reset");
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                $('#formModalHeading1').html("<i class='fa fa-plus'></i> Create Data");
                $('#formModal1').modal('show');
            });

            $('body').on('click', '.editData', function() {
                var id = $(this).data('id');
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                $.get("{{ route('admin.discount-show', '') }}/" + id, function(data) {
                    $('#formModalHeading1').html(
                        "<i class='fa-regular fa-pen-to-square'></i> Edit Data");
                    $('#formModal1').modal('show');
                    $('#id').val(data.response.id);
                    $('#name').val(data.response.name);
                    $('#code').val(data.response.code);
                    $('#quota').val(formatQuota(data.response.quota));
                    $('#amount').val(formatAmount(data.response.amount));
                })
            });

            $('#dataForm1').submit(function(e) {
                e.preventDefault();
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                let formData = new FormData(this);
                $('#saveBtn').html('Sending...');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.discount-store') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: (response) => {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').trigger("reset");
                        $('#formModal1').modal('hide');
                        table.draw();
                    },
                    error: function(response) {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').find(".print-error-msg").find("ul").html('');
                        $('#dataForm1').find(".print-error-msg").css('display', 'block');
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#dataForm1').find(".print-error-msg").find("ul")
                                .append('<li>' + value + '</li>');
                        });
                    }
                });

            });

            $('body').on('click', '.deleteData', function() {
                var id = $(this).data("id");
                var isConfirmed = confirm("Are You sure want to delete?");

                if (isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "{{ route('admin.discount-delete', '') }}/" + id,
                        success: function(data) {
                            table.draw();
                        },
                        error: function(data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

        });
    </script>
@endsection
