@extends('layouts.admin')
@section('css')
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>Post</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Discount</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="card">
                <div class="card-body">
                    <div class="d-grid gap-2 d-md-flex mb-3">
                        <a class="btn btn-success btn-sm" href="javascript:void(0)" id="createNewData"> <i
                                class="fa fa-plus"></i> Create</a>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover text-nowrap data-table w-100">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Name</th>
                                    <th>Code</th>
                                    <th>Quota</th>
                                    <th>Used</th>
                                    <th>Amount</th>
                                    <th>Expired</th>
                                    <th width="100px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <div class="modal fade" id="ajaxModal" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modelHeading"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="dataForm" name="dataForm" class="form-horizontal">
                        <input type="hidden" name="id" id="id">
                        @csrf
                        <div class="alert alert-danger print-error-msg" style="display:none">
                            <ul></ul>
                        </div>

                        <div class="form-group">
                            <label for="name" class="col-sm-2 control-label">Name</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="name" name="name"
                                    placeholder="Enter Name">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="code" class="col-sm-2 control-label">Code</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="code" name="code"
                                    placeholder="Enter Code">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="quota" class="col-sm-2 control-label">Quota</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="quota" name="quota"
                                    placeholder="Enter Quota">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="amount" class="col-sm-2 control-label">Amount</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control" id="amount" name="amount"
                                    placeholder="Enter Amount">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="expires_at" class="col-sm-2 control-label">Expired</label>
                            <div class="col-sm-12">
                                <div class="row">
                                    <div class="col-6 col-sm-4">
                                        <input type="date" class="form-control" id="expires_at" name="expires_at"
                                            placeholder="Enter Expired" value="{{ date('Y-m-d') }}">
                                    </div>
                                    <div class="col-6 col-sm-3">
                                        <input type="time" class="form-control" id="expires_at_time"
                                            name="expires_at_time" placeholder="Enter Expired" value="{{ date('H:i') }}">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-sm-offset-2 col-sm-10">
                            <button type="submit" class="btn btn-success mt-2" id="saveBtn">Submit</button>
                            <button type="button" class="btn btn-danger mt-2" id="cancelBtn" data-dismiss="modal"><i
                                    class="fa fa-cancel"></i>
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(function() {
            var table = $('.data-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.discount.index') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'code',
                        name: 'code'
                    },
                    {
                        data: 'quota',
                        name: 'quota',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    },
                    {
                        data: 'quota_used',
                        name: 'quota_used',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    },
                    {
                        data: 'amount',
                        name: 'amount',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2
                            }).format(data);
                        }
                    },
                    {
                        data: 'expires_at',
                        name: 'expires_at'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

            function formatQuota(value) {
                value = String(value);
                value = value.replace(/[^0-9.]/g, '');
                if ((value.match(/\./g) || []).length > 1) {
                    value = value.replace(/\.+$/, "");
                }
                var parts = value.split('.');
                parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ',');
                if (parts.length === 1) {
                    return parts[0];
                }
                if (parts.length > 1 && parts[1] === '00') {
                    return parts[0];
                }
                return parts.join('.');
            }

            function formatAmount(value) {
                value = String(value);
                value = value.replace(/[^0-9.]/g, '');
                if ((value.match(/\./g) || []).length > 1) {
                    value = value.replace(/\.+$/, "");
                }
                var parts = value.split('.');
                parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ',');

                return parts.join('.');
            }

            $('#quota').on('input', function() {
                $(this).val(formatQuota($(this).val()));
            });

            $('#amount').on('input', function() {
                $(this).val(formatAmount($(this).val()));
            });

            $('#createNewData').click(function() {
                $('#id').val('');
                $('#dataForm').trigger("reset");
                $('#modelHeading').html("<i class='fa fa-plus'></i> New Data");
                $('#ajaxModal').modal('show');
            });

            $('body').on('click', '.editData', function() {
                var id = $(this).data('id');
                $.get("{{ route('admin.discount.index') }}" + '/' + id + '/edit', function(data) {
                    $('#modelHeading').html(
                        "<i class='fa-regular fa-pen-to-square'></i> Edit Data");
                    $('#ajaxModal').modal('show');
                    $('#id').val(data.id);
                    $('#name').val(data.name);
                    $('#code').val(data.code);
                    $('#quota').val(formatQuota(data.quota));
                    $('#amount').val(formatAmount(data.amount));
                })
            });

            $('#dataForm').submit(function(e) {
                e.preventDefault();
                let formData = new FormData(this);
                $('#saveBtn').html('Sending...');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.discount.store') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: (response) => {
                        $('#saveBtn').html('Submit');
                        $('#dataForm').trigger("reset");
                        $('#ajaxModal').modal('hide');
                        table.draw();
                    },
                    error: function(response) {
                        $('#saveBtn').html('Submit');
                        $('#dataForm').find(".print-error-msg").find("ul").html('');
                        $('#dataForm').find(".print-error-msg").css('display', 'block');
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#dataForm').find(".print-error-msg").find("ul")
                                .append('<li>' + value + '</li>');
                        });
                    }
                });

            });

            $('body').on('click', '.deleteData', function() {
                var id = $(this).data("id");
                var isConfirmed = confirm("Are You sure want to delete?");

                if (isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "{{ route('admin.discount.store') }}" + '/' + id,
                        success: function(data) {
                            table.draw();
                        },
                        error: function(data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

        });
    </script>
@endsection
