@extends('layouts.admin')
@section('css')
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>VPS Detail</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">VPS Detail</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <div class="card">
                <div class="card-body">
                    <div class="d-grid gap-2 d-md-flex mb-3">
                        <a class="btn btn-success btn-sm" href="javascript:void(0)" id="createData"> <i
                                class="fa fa-plus"></i> Create</a>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-sm table-hover text-nowrap data-table w-100">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Category</th>
                                    <th>Country</th>
                                    <th>VPS Name</th>
                                    <th>Proxies</th>
                                    <th>Quota</th>
                                    <th>Quota Used</th>
                                    <th>Price</th>
                                    <th>Price Hour</th>
                                    <th>Data Limit</th>
                                    <th>Status</th>
                                    <th width="100px">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card-body -->
            </div>
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <div class="modal fade" id="formModal1" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="formModalHeading1"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="dataForm1" name="dataForm1" class="form-horizontal">
                        <input type="hidden" name="id" id="id">
                        @csrf
                        <div class="alert alert-danger print-error-msg" style="display:none">
                            <ul></ul>
                        </div>
                        <div class="form-group">
                            <label for="vps_category_id" class="col-sm-12 control-label">Category</label>
                            <div class="col-sm-12">
                                <select class="form-control select2" id="vps_category_id" name="vps_category_id"
                                    placeholder="Select Category"></select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="vps_id" class="col-sm-12 control-label">VPS</label>
                            <div class="col-sm-12">
                                <select class="form-control select2" id="vps_id" name="vps_id"
                                    placeholder="Select VPS"></select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="vps_proxies_id" class="col-sm-12 control-label">Proxies</label>
                            <div class="col-sm-12">
                                <select class="form-control select2" id="vps_proxies_id" name="vps_proxies_id"
                                    placeholder="Select Proxies">
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="price" class="col-sm-12 control-label">Price</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control price" id="price" name="price"
                                    placeholder="Enter Price">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="price_hour" class="col-sm-12 control-label">Price Hour</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control price" id="price_hour" name="price_hour"
                                    placeholder="Enter Price Hour">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="quota" class="col-sm-12 control-label">Quota</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control quota" id="quota" name="quota"
                                    placeholder="Enter Quota">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="quota_used" class="col-sm-12 control-label">Quota Used</label>
                            <div class="col-sm-12">
                                <input type="text" class="form-control quota" id="quota_used"
                                    placeholder="Enter Quota Used" readonly>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="max_session" class="col-sm-12 control-label">Max Session</label>
                            <div class="col-sm-12">
                                <input type="number" class="form-control" id="max_session" name="max_session"
                                    placeholder="Enter Data Limit (GB)" value="3">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="data_limit" class="col-sm-12 control-label">Data Limit (GB)</label>
                            <div class="col-sm-12">
                                <input type="number" class="form-control" id="data_limit" name="data_limit"
                                    placeholder="Enter Data Limit (GB)" value="0">
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="data_limit_reset_strategy" class="col-sm-12 control-label">Data Limit Reset
                                Strategy</label>
                            <div class="col-sm-12">
                                <select class="form-control" id="data_limit_reset_strategy"
                                    name="data_limit_reset_strategy">
                                    <option value="no_reset">no_reset</option>
                                    <option value="day">day</option>
                                    <option value="week">week</option>
                                    <option value="month">month</option>
                                    <option value="year">year</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label for="is_pay" class="col-sm-12 control-label">Payment Type</label>
                            <div class="col-sm-12">
                                <select class="form-control" id="is_pay" name="is_pay">
                                    <option value="1">Pay As You Go</option>
                                    <option value="0">Monthly</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-offset-2 col-sm-10">
                            <button type="submit" class="btn btn-success mt-2" id="saveBtn">Submit</button>
                            <button type="button" class="btn btn-danger mt-2" id="cancelBtn" data-dismiss="modal"><i
                                    class="fa fa-cancel"></i>
                                Cancel
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        $(function() {
            $('#price').on('input', function() {
                $('#price_hour').val(formatAmountHour($(this).val()));
            });

            $('#vps_category_id').select2({
                placeholder: 'Select Category',
                ajax: {
                    url: "{{ route('admin.vps-category-select') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term,
                            page: params.page || 1
                        };
                    },
                    processResults: function(data, params) {
                        params.page = params.page || 1;
                        return {
                            results: data.data,
                            pagination: {
                                more: data.next_page_url !== null
                            }
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0,
            });

            $('#vps_id').select2({
                placeholder: 'Select VPS',
                ajax: {
                    url: "{{ route('admin.vps-server-select') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term,
                            page: params.page || 1
                        };
                    },
                    processResults: function(data, params) {
                        params.page = params.page || 1;
                        return {
                            results: data.data,
                            pagination: {
                                more: data.next_page_url !== null
                            }
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0,
            });

            $('#vps_proxies_id').select2({
                placeholder: 'Select Proxies',
                ajax: {
                    url: "{{ route('admin.vps-proxies-select') }}",
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            q: params.term,
                            page: params.page || 1
                        };
                    },
                    processResults: function(data, params) {
                        params.page = params.page || 1;

                        return {
                            results: data.data,
                            pagination: {
                                more: data.next_page_url !== null
                            }
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0,
            });

            var table = $('.data-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.vps-detail') }}",
                columns: [{
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'vps_category_name',
                        name: 'vps_categories.name'
                    },
                    {
                        data: 'vps_country_name',
                        name: 'vps_countries.name'
                    },
                    {
                        data: 'vps_name',
                        name: 'vps.name'
                    },
                    {
                        data: 'vps_proxies_name',
                        name: 'vps_proxies.name'
                    },
                    {
                        data: 'quota',
                        name: 'quota',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    },
                    {
                        data: 'quota_used',
                        name: 'quota_used',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 0,
                                maximumFractionDigits: 0
                            }).format(data);
                        }
                    },
                    {
                        data: 'price',
                        name: 'price',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2
                            }).format(data);
                        }
                    },
                    {
                        data: 'price_hour',
                        name: 'price_hour',
                        render: function(data, type, row) {
                            return new Intl.NumberFormat('en-US', {
                                minimumFractionDigits: 2,
                                maximumFractionDigits: 2
                            }).format(data);
                        }
                    },
                    {
                        data: 'limit',
                        name: 'limit'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                ]
            });

            $('#createData').click(function() {
                $('#id').val('');
                $("#vps_id").val(null).change();
                $("#vps_category_id").val(null).change();
                $("#vps_proxies_id").val(null).change();
                $('#dataForm1').trigger("reset");
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                $('#formModalHeading1').html("<i class='fa fa-plus'></i> Create Data");
                $('#formModal1').modal('show');
            });

            $('body').on('click', '.editData', function() {
                $('#id').val('');
                $("#vps_id").val(null).change();
                $("#vps_category_id").val(null).change();
                $("#vps_proxies_id").val(null).change();
                $("#data_limit_reset_strategy").val(null).change();
                $('#dataForm1').trigger("reset");
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                $('#formModalHeading1').html(
                    "<i class='fa-regular fa-pen-to-square'></i> Edit Data");
                var id = $(this).data('id');
                $.get("{{ route('admin.vps-detail-show', '') }}/" + id, function(data) {
                    data = data.response;
                    console.log(data);
                    $('#formModal1').modal('show');
                    $('#id').val(data.id);
                    $("#vps_id").append(new Option(data.vps_name, data.vps_id, true, true))
                        .change();
                    $("#vps_category_id").append(new Option(data.vps_category_name, data
                        .vps_category_id, true, true)).change();
                    $("#vps_proxies_id").append(new Option(data.vps_proxies_name, data
                        .vps_proxies_id, true, true)).change();
                    $('#price').val(formatAmount(data.price));
                    $('#price_hour').val(formatAmount(data.price_hour));
                    $('#quota').val(formatQuota(data.quota));
                    $('#quota_used').val(formatQuota(data.quota_used));
                    $('#max_session').val(data.max_session);
                    $('#data_limit').val(data.data_limit);
                    $('#data_limit_reset_strategy').val(data
                        .data_limit_reset_strategy);
                    $('#is_pay').val(data.is_pay);
                })
            });

            $('#dataForm1').submit(function(e) {
                e.preventDefault();
                $('#dataForm1').find(".print-error-msg").find("ul").html('');
                $('#dataForm1').find(".print-error-msg").css('display', 'none');
                let formData = new FormData(this);
                $('#saveBtn').html('Sending...');
                $.ajax({
                    type: 'POST',
                    url: "{{ route('admin.vps-detail-store') }}",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: (response) => {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').trigger("reset");
                        $('#formModal1').modal('hide');
                        table.draw();
                    },
                    error: function(response) {
                        $('#saveBtn').html('Submit');
                        $('#dataForm1').find(".print-error-msg").find("ul").html('');
                        $('#dataForm1').find(".print-error-msg").css('display', 'block');
                        $.each(response.responseJSON.errors, function(key, value) {
                            $('#dataForm1').find(".print-error-msg").find("ul")
                                .append('<li>' + value + '</li>');
                        });
                    }
                });

            });

            $('body').on('click', '.deleteData', function() {
                var id = $(this).data("id");
                var isConfirmed = confirm("Are You sure want to delete?");

                if (isConfirmed) {
                    $.ajax({
                        type: "DELETE",
                        url: "{{ route('admin.vps-detail-delete', '') }}/" + id,
                        success: function(data) {
                            table.draw();
                        },
                        error: function(data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

        });
    </script>
@endsection
