<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-light-primary elevation-4">
    <!-- Brand Logo -->
    <a href="#" class="brand-link border-0">
        <img src="{{ asset('dist/img/logoapp.png') }}" alt="LingVPN Logo" class="brand-image img-circle elevation-3"
            style="opacity: .8">
        <span class="brand-text font-weight-light">LingVPN</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">
                @auth
                    @if (auth()->user()->role == 'admin')
                        <li class="nav-item rounded ">
                            <a href="{{ route('member.index') }}" class="nav-link">
                                <i class="nav-icon fas fa-arrow-left"></i>
                                <p>Change to Panel Member</p>
                            </a>
                        </li>
                    @endif
                @endauth
                <li class="nav-item">
                    <a href="{{ route('admin.index') }}"
                        class="nav-link{{ request()->routeIs('admin.index') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-chart-pie"></i>
                        <p>Dashboard</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.billing') }}"
                        class="nav-link{{ request()->routeIs('admin.billing') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-file-invoice-dollar"></i>
                        <p>Billing</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.invoice') }}"
                        class="nav-link{{ request()->routeIs('admin.invoice') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-file-invoice"></i>
                        <p>Invoice</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.discount') }}"
                        class="nav-link{{ request()->routeIs('admin.discount') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-bookmark"></i>
                        <p>Discount</p>
                    </a>
                </li>
                <li
                    class="nav-item{{ request()->routeIs(['admin.vps-server.index', 'admin.vps-proxies', 'admin.vps-detail', 'admin.vps-category', 'admin.vps-country']) ? ' menu-is-opening menu-open' : '' }}">
                    <a href="#"
                        class="nav-link{{ request()->routeIs(['admin.vps-server.index', 'admin.vps-proxies', 'admin.vps-detail', 'admin.vps-category', 'admin.vps-country']) ? ' active' : '' }}">
                        <i class="nav-icon fas fa-database"></i>
                        <p>
                            VPS
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="{{ route('admin.vps-country') }}"
                                class="nav-link{{ request()->routeIs('admin.vps-country') ? ' active' : '' }}">
                                <i class="nav-icon far fa-circle"></i>
                                <p>Country</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.vps-category') }}"
                                class="nav-link{{ request()->routeIs('admin.vps-category') ? ' active' : '' }}">
                                <i class="nav-icon far fa-circle"></i>
                                <p>Category</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.vps-proxies') }}"
                                class="nav-link{{ request()->routeIs('admin.vps-proxies') ? ' active' : '' }}">
                                <i class="nav-icon far fa-circle"></i>
                                <p>Proxies</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.vps-server.index') }}"
                                class="nav-link{{ request()->routeIs('admin.vps-server.index') ? ' active' : '' }}">
                                <i class="nav-icon far fa-circle"></i>
                                <p>Server</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('admin.vps-detail') }}"
                                class="nav-link{{ request()->routeIs('admin.vps-detail') ? ' active' : '' }}">
                                <i class="nav-icon far fa-circle"></i>
                                <p>Detail</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.subscription') }}"
                        class="nav-link{{ request()->routeIs('admin.subscription') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-shopping-bag"></i>
                        <p>Subscription</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.user') }}"
                        class="nav-link{{ request()->routeIs('admin.user') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-users"></i>
                        <p>Users</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('admin.information') }}"
                        class="nav-link{{ request()->routeIs('admin.information') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-bullhorn"></i>
                        <p>Information</p>
                    </a>
                </li>
                {{-- <li class="nav-item">
                    <a href="{{ route('admin.feedback') }}"
                        class="nav-link{{ request()->routeIs('admin.feedback') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-edit"></i>
                        <p>Feedback</p>
                    </a>
                </li> --}}
                {{-- <li class="nav-item">
                    <a href="{{ route('admin.blog') }}"
                        class="nav-link{{ request()->routeIs('admin.blog') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-file"></i>
                        <p>Blog</p>
                    </a>
                </li> --}}
                <li class="nav-item">
                    <a href="{{ route('admin.setting') }}"
                        class="nav-link{{ request()->routeIs('admin.setting') ? ' active' : '' }}">
                        <i class="nav-icon fas fa-cogs"></i>
                        <p>Setting</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="#" class="nav-link">
                        <i class="nav-icon fas fa-code-branch"></i>
                        <p>Version 0.1.0</p>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="{{ route('logout') }}" class="nav-link">
                        <i class="nav-icon fas fa-sign-out-alt"></i>
                        <p>Logout</p>
                    </a>
                </li>
            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>
