<!DOCTYPE html>
<!--
This is a starter template page. Use this page to start your new project from
scratch. This page gets rid of all links and provides the needed markup only.
-->
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard | LingVPN</title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="{{ asset('plugins/fontawesome-free/css/all.min.css') }}">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('plugins/toastr/toastr.min.css') }}">
    <link rel="stylesheet" href="{{ asset('dist/css/adminlte.min.css') }}">
    <style>
        a {
            color: #000000;
        }

        .card {
            height: 100%;
        }

        .card-body {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .card img {
            max-width: 100%;
            height: auto;
        }

        .card hr {
            margin: 15px 0;
            width: 100%;
        }

        .tag-cloud h6::before {
            content: "✅";
            margin-right: 5px;
        }

        .dropdown-item.active,
        .dropdown-item:active {
            color: #fff;
            text-decoration: none;
            background-color: #000000;
        }
    </style>
    @yield('css')
</head>

<body class="hold-transition layout-top-nav">
    <div class="wrapper">
        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand-md navbar-light navbar-white">
            <div class="container">
                <a href="{{ url('/') }}" class="navbar-brand">
                    <img src="{{ asset('dist/img/logoapp.png') }}" alt="LingVPN Logo"
                        class="brand-image img-circle elevation-3" style="opacity: .8">
                    <span class="brand-text font-weight-light">LingVPN</span>
                </a>

                <button class="navbar-toggler order-1" type="button" data-toggle="collapse"
                    data-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false"
                    aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>

                <div class="collapse navbar-collapse order-3" id="navbarCollapse">
                    <!-- Left navbar links -->
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <a href="{{ route('index') }}"
                                class="nav-link{{ request()->routeIs('index') ? ' active' : '' }}">Home</a>
                        </li>
                        <li class="nav-item">
                            <a href="{{ route('pricing') }}"
                                class="nav-link{{ request()->routeIs('pricing') ? ' active' : '' }}">Pricing</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a id="dropdownSubMenu1" href="#" data-toggle="dropdown" aria-haspopup="true"
                                aria-expanded="false"
                                class="nav-link dropdown-toggle{{ ((request()->routeIs('tools-data-center') ? ' active' : request()->routeIs('tools-account-remaining')) ? ' active' : request()->routeIs('tools-host-to-ip')) ? ' active' : '' }}">Tools</a>
                            <ul aria-labelledby="dropdownSubMenu1" class="dropdown-menu border-0 shadow">
                                <li><a href="{{ route('tools-data-center') }}"
                                        class="dropdown-item{{ request()->routeIs('tools-data-center') ? ' active' : '' }}">Data
                                        Center </a>
                                </li>
                                <li><a href="{{ route('tools-host-to-ip') }}"
                                        class="dropdown-item{{ request()->routeIs('tools-host-to-ip') ? ' active' : '' }}">Host
                                        to
                                        IP</a>
                                </li>
                            </ul>
                        </li>
                        {{-- <li class="nav-item">
                            <a href="{{ route('blog') }}"
                                class="nav-link{{ request()->routeIs('blog') ? ' active' : '' }}">Blog</a>
                        </li> --}}
                    </ul>
                    @if (Route::has('login'))
                        <ul class="order-1 order-md-3 navbar-nav ml-auto">
                            @auth
                                <li class="nav-item bg-dark rounded text-center">
                                    <a href="{{ auth()->user()->role == 'admin' ? '/admin' : '/member' }}"
                                        class="nav-link"><i class="fa fa-home"></i> Dashboard</a>
                                </li>
                                <li class="nav-item text-center">
                                    <a href="{{ route('logout') }}" class="nav-link"><i class="fa fa-sign-out-alt"></i>
                                        Logout</a>
                                </li>
                            @else
                                @if (Route::has('register'))
                                    <li class="nav-item text-center">
                                        <a href="{{ route('register') }}" class="nav-link bg-dark rounded"><i
                                                class="fa fa-user-plus"></i>
                                            Register</a>
                                    </li>
                                @endif
                                <li class="nav-item text-center">
                                    <a href="{{ route('login') }}" class="nav-link"><i class="fa fa-sign-in-alt"></i>
                                        Login</a>
                                </li>
                            @endauth
                        </ul>
                    @endif
                </div>

            </div>
        </nav>
        <!-- /.navbar -->

        <div class="content-wrapper">
            @yield('content')
            <div class="container">
                <hr>
                <div class="row">
                    <div class="col-12">
                        <h3 class="text-center">Fitur Layanan</h3>
                    </div>
                    <div class="col-12 py-3">
                        <div class="card">
                            <div class="card-body">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item">Menggunakan Core Xray yang sudah
                                        teroptimasi secara kuat dan
                                        management panel oleh Marzban.</li>
                                    <li class="list-group-item">Support SNI (dengan syarat) dan CDN Cloudflare.</li>
                                    <li class="list-group-item">Support Wildcard Domain Cloudflare untuk semua server.
                                    </li>
                                    <li class="list-group-item">Support Port HTTPS/TLS 443, 8443, 8880.</li>
                                    <li class="list-group-item">Support Port HTTP/NonTLS 80, 2082, 2083, 3128, 8080,
                                        8000.</li>
                                    <li class="list-group-item">Support Layanan VOD lock region Indo (Netflix, Vidio,
                                        Primevidio, Disney+ Hotstar, Youtube Premium, Viu, iQiyi, WeTV). Jika ada
                                        website atau
                                        situs yang belum bisa dibuka, konfirmasi ke Admin Via Telegram PM.</li>
                                    <li class="list-group-item">Compatible dengan aplikasi client seperti
                                        Clash/Clash.Meta,
                                        V2ray-core, Xray-core.</li>
                                    <li class="list-group-item">Tersedia Custom WebSocket dan HTTP Upgrade Path seperti
                                        AntiADS
                                        dan AntiPORN! <strong>Say goodbye kepada Iklan yang mengganggu saat anda
                                            browsing dan
                                            lindungi keluarga anda terhadap pornografi hanya dengan menggunakan layanan
                                            VPN
                                            kami!</strong></li>
                                    <li class="list-group-item">Cek penggunaan data kamu secara Real-time menggunakan
                                        Subs Link
                                        pada setiap pembelian akun.</li>
                                    <li class="list-group-item">Khusus untuk server ID BiznetGIO, Akses Youtube dan
                                        Playstore
                                        sudah aman.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <hr>
                <div class="row">
                    <div class="col-12">
                        <h3 class="text-center">Mengapa menggunakan LingVPN?</h3>
                    </div>
                    <div class="col-12 py-3">
                        <div class="row tag-cloud">
                            <div class="col-lg-2 col-6">
                                <h6>No limit speed</h6>
                            </div>
                            <div class="col-lg-2 col-6">
                                <h6>Powerfull server</h6>
                            </div>
                            <div class="col-lg-2 col-6">
                                <h6>Global network</h6>
                            </div>
                            <div class="col-lg-2 col-6">
                                <h6>Double encryption</h6>
                            </div>
                            <div class="col-lg-2 col-6">
                                <h6>2 multi logins</h6>
                            </div>
                            <div class="col-lg-2 col-6">
                                <h6>Bypass restrictions</h6>
                            </div>
                            <div class="col-lg-2 col-6">
                                <h6>Easy to create</h6>
                            </div>
                            <div class="col-lg-2 col-6">
                                <h6>Daily Update</h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="bg-danger">
                <div class="container">
                    <div class="row pt-1 text-center">
                        <div class="col-lg-6">
                            <h5>Current Time - <span id="clock"></span>
                            </h5>
                        </div>
                        <div class="col-lg-6">
                            <h5>Reset Time - 08:00:00 PM</h5>
                        </div>
                    </div>
                </div>
            </div>
            <div class="bg-dark">
                <div class="container">
                    <div class="row p-3">
                        <div class="col-6 col-md">
                            <h5>Services</h5>
                            <ul class="list-unstyled text-small">
                                <li><a class="text-white" href="{{ route('pricing') }}">Shadowsocks</a></li>
                                <li><a class="text-white" href="{{ route('pricing') }}">Vmess</a></li>
                                <li><a class="text-white" href="{{ route('pricing') }}">Vless</a></li>
                                <li><a class="text-white" href="{{ route('pricing') }}">Trojan</a></li>
                            </ul>
                        </div>
                        <div class="col-6 col-md">
                            <h5>Features</h5>
                            <ul class="list-unstyled text-small">
                                <li><a class="text-white" href="{{ route('tools-data-center') }}">Data Center</a>
                                </li>
                                <li><a class="text-white" href="{{ route('tools-host-to-ip') }}">Host to IP</a></li>
                            </ul>
                        </div>
                        <div class="col-6 col-md">
                            <h5>Company</h5>
                            <ul class="list-unstyled text-small">
                                {{-- <li><a class="text-white" href="{{ route('blog') }}">Blog</a></li> --}}
                                <li><a class="text-white" href="{{ route('sitemap') }}">Sitemap</a></li>
                                <li><a class="text-white" href="{{ route('term-of-service') }}">Term of service</a>
                                </li>
                                <li><a class="text-white" href="{{ route('privacy-policy') }}">Privacy policy</a>
                                </li>
                                {{-- <li><a class="text-white" href="{{ route('disclaimer') }}">Disclaimer</a></li> --}}
                            </ul>
                        </div>
                        <div class="col-6 col-md">
                            <h5>About</h5>
                            <p>Ling VPN is the best tunneling accounts provider. Get Free account and premium with pay
                                as you go payment systems.</p>
                            <p><strong>Telegram: </strong><a class="text-white"
                                    href="mailto:admin@lingvpn.net?Subject=Hello" target="_top">@lingvpn</a></br />
                                <strong>Email: </strong><a class="text-white"
                                    href="mailto:admin@lingvpn.net?Subject=Hello" target="_top">admin@lingvpn.net</a>
                            </p>
                        </div>
                    </div>
                </div>
                <footer class="main-footer">
                    <div class="float-right d-none d-sm-block">
                        <b>Version</b> 0.1.1
                    </div>
                    <strong>&copy; {{ date('Y') == 2024 ? date('Y') : '2024-' . date('Y') }} <a class=""
                            href="#">LingVPN</a>.</strong> All rights reserved.
                </footer>
            </div>
        </div>
        <!-- /.content-wrapper -->
    </div>
    <!-- ./wrapper -->

    <!-- REQUIRED SCRIPTS -->

    <!-- jQuery -->
    <script src="{{ asset('plugins/jquery/jquery.min.js') }}"></script>
    <!-- Bootstrap 4 -->
    <script src="{{ asset('plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <!-- AdminLTE App -->
    <script src="{{ asset('dist/js/adminlte.min.js') }}"></script>
    {!! NoCaptcha::renderJs() !!}
    <script>
        $(function() {
            updateTime();
            setInterval(updateTime, 1000);
        });

        function updateTime() {
            var now = new Date();
            var hours = now.getHours();
            var minutes = now.getMinutes();
            var seconds = now.getSeconds();
            var ampm = hours >= 12 ? 'PM' : 'AM';
            hours = hours % 12;
            hours = hours ? hours : 12;
            hours = hours < 10 ? '0' + hours : hours;
            minutes = minutes < 10 ? '0' + minutes : minutes;
            seconds = seconds < 10 ? '0' + seconds : seconds;
            var timeString = hours + ':' + minutes + ':' + seconds + ' ' + ampm;

            $('#clock').text(timeString);
        }
    </script>
    @yield('js')
</body>

</html>
