@extends('layouts.member')
@section('css')
    <style>
        a {
            color: #000000;
        }

        .nav-pills .nav-link.active,
        .nav-pills .show>.nav-link {
            color: #fff;
            background-color: #343a40;
        }
    </style>
@endsection
@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <div class="container-fluid">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1>My Product</h1>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">My Product</li>
                        </ol>
                    </div>
                </div>
            </div><!-- /.container-fluid -->
        </section>

        <!-- Main content -->
        <section class="content">
            <!-- Default box -->
            @foreach ($information as $item)
                <div class="alert alert-{{ $item->category }} alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                    {{ $item->name }} {{ $item->description }}
                </div>
            @endforeach
            <div class="card">
                <div class="card-header d-flex p-0">
                    <ul class="nav nav-pills p-2">
                        @foreach ($vps_category as $key => $val)
                            <li class="nav-item"><a class="nav-link{{ $key == 0 ? ' active' : '' }}"
                                    href="#tab_{{ $key }}" data-toggle="tab">
                                    {{ $val->name }} <span
                                        class="badge badge-danger right">{{ isset($vps_subscription_group[$val->id]) ? count($vps_subscription_group[$val->id]) : '0' }}</span>
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="tab-content">
                        @foreach ($vps_category as $key => $val)
                            <div class="tab-pane text-center{{ $key == 0 ? ' active' : '' }}" id="tab_{{ $key }}">
                                <div class="row">
                                    @if (isset($vps_subscription_group[$val->id]))
                                        @foreach ($vps_subscription_group[$val->id] as $item)
                                            <div class="col-sm-4">
                                                <div class="card">
                                                    <div class="card-header text-center m-0 p-0">
                                                        <h5 class="m-0 p-1">
                                                            {{ Str::upper($item->vps_country_code) }}
                                                            {{ Str::upper($item->vps_proxies_name) }}
                                                            {{ Str::upper($item->vps_name) }}
                                                        </h5>
                                                    </div>
                                                    <!-- /.card-header -->
                                                    <div class="card-body m-o p-1">
                                                        <div class="row">
                                                            <div class="col-6 text-left">
                                                                <span><i class="me-1 md far fa-question-circle"
                                                                        role="img" aria-label="help circle outline"></i>
                                                                    Status</span>
                                                            </div>
                                                            <div class="col-6 text-right">
                                                                <span><strong
                                                                        class="{{ $item->deleted_at == null ? 'text-success' : 'text-danger' }}">{{ $item->deleted_at == null ? 'active' : 'disabled' }}</strong></span>
                                                            </div>
                                                            <div class="col-6 text-left">
                                                                <span><i class="me-1 md fa fa-map-marker" role="img"
                                                                        aria-label="help circle outline"></i>
                                                                    Location</span>
                                                            </div>
                                                            <div class="col-6 text-right">
                                                                <span>{{ Str::lower($item->vps_country_name) }}</span>
                                                            </div>
                                                            <div class="col-6 text-left">
                                                                <span><i class="me-1 md far fa-user-circle" role="img"
                                                                        aria-label="help circle outline"></i>
                                                                    User</span>
                                                            </div>
                                                            <div class="col-6 text-right">
                                                                <span>{{ $item->username }}</span>
                                                            </div>
                                                            <div class="col-6 text-left">
                                                                <span><i class="me-1 md far fa-check-circle" role="img"
                                                                        aria-label="help circle outline"></i>
                                                                    Active</span>
                                                            </div>
                                                            <div class="col-6 text-right">
                                                                @php
                                                                    $createdAt = \Carbon\Carbon::parse(
                                                                        $item->created_at,
                                                                    )->setTimezone('Asia/Jakarta');
                                                                    $now = \Carbon\Carbon::now('Asia/Jakarta');
                                                                    $diff = $createdAt->diff($now);
                                                                    $parts = [];
                                                                    if ($diff->d > 0) {
                                                                        $parts[] = $diff->d . ' Days';
                                                                    }
                                                                    if ($diff->h > 0) {
                                                                        $parts[] = $diff->h . ' Hours';
                                                                    }
                                                                    if (
                                                                        $diff->d == 0 &&
                                                                        $diff->h == 0 &&
                                                                        $diff->i > 0
                                                                    ) {
                                                                        $parts[] = $diff->i . ' Minutes';
                                                                    }
                                                                    if (
                                                                        $diff->d == 0 &&
                                                                        $diff->h == 0 &&
                                                                        $diff->i == 0 &&
                                                                        $diff->s > 0
                                                                    ) {
                                                                        $parts[] = $diff->s . ' Seconds';
                                                                    }
                                                                    $usageDuration = implode(', ', $parts);
                                                                @endphp
                                                                <span>{{ $usageDuration }}</span>
                                                            </div>
                                                            <div class="col-6 text-left">
                                                                <span><i class="me-1 md fa fa-globe" role="img"
                                                                        aria-label="help circle outline"></i>
                                                                    Max Session</span>
                                                            </div>
                                                            <div class="col-6 text-right">
                                                                <span>{{ $item->vps_max_session }} IP</span>
                                                            </div>
                                                            <div class="col-6 text-left">
                                                                <span><i class="me-1 md fas fa-file-invoice-dollar"
                                                                        role="img" aria-label="help circle outline"></i>
                                                                    Charge Credit</span>
                                                            </div>
                                                            <div class="col-6 text-right">
                                                                <span>IDR
                                                                    {{ number_format($item->balance, 2, '.', ',') }}</span>
                                                            </div>
                                                            <div class="col-6 text-left">
                                                                <span><i class="me-1 md far fa-file-alt" role="img"
                                                                        aria-label="help circle outline"></i>
                                                                    Charge Point</span>
                                                            </div>
                                                            <div class="col-6 text-right">
                                                                <span>IDR
                                                                    {{ number_format($item->vps_price_hour, 2, '.', ',') }}</span>
                                                            </div>
                                                            @if ($item->deleted_at != null)
                                                                <div class="col-12 my-1">
                                                                    <button
                                                                        class="btn-block btn btn-sm btn-danger my-2">Maintenance</button>
                                                                </div>
                                                            @endif
                                                            <div class="col-6 text-left my-1">
                                                                <button
                                                                    class="btn-block btn btn-sm btn-primary my-2 detail-account"
                                                                    data-id="{{ $item->id }}">Detail</button>
                                                            </div>
                                                            <div class="col-6 text-right my-1">
                                                                <button
                                                                    class="btn-block btn btn-sm btn-danger my-2 delete-account"
                                                                    data-id="{{ $item->id }}"
                                                                    data-username="{{ $item->username }}"
                                                                    data-name="{{ Str::upper($item->vps_country_code) . ' ' . Str::upper($item->vps_proxies_name) . ' ' . Str::upper($item->vps_name) }}">Delete</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- /.card-body -->
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <h4 class="rounded-pill btn-block bg-danger mt-2 p-2">Empty Account</h4>
                                    @endif
                                </div>
                            </div><!-- /.tab-content -->
                        @endforeach
                    </div>
                    <!-- /.tab-pane -->
                </div><!-- /.card-body -->
            </div>
        </section>
        <!-- /.content -->
        {{-- <a id="createAccount" href="javascript:void(0)" class="btn btn-dark back-to-top img-circle text-center"
            role="button" aria-label="Create Account">
            <i class="fas fa-plus"></i>
        </a> --}}
    </div>
    <!-- /.content-wrapper -->
@endsection
@section('js')
    @include('member.product_modal_js')
    <script>
        $(function() {
            $('.delete-account').on('click', function() {
                var id = $(this).data('id');
                var username = $(this).data('username');
                var name = $(this).data('name');
                Swal.fire({
                    title: name,
                    text: `username "${username}" will be deleted?`,
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Yes, delete it!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            url: "{{ route('member.product-delete') }}",
                            type: "POST",
                            data: {
                                id: id,
                                _token: "{{ csrf_token() }}"
                            },
                            success: function(res) {
                                if (res.metadata.code == 200) {
                                    Swal.fire({
                                        title: "Deleted!",
                                        text: "Your file has been deleted.",
                                        icon: "success"
                                    }).then((result) => {
                                        location.reload();
                                    });
                                } else {
                                    Swal.fire({
                                        title: "Failed!",
                                        text: "Your file has been failed.",
                                        icon: "error"
                                    });
                                }
                            }
                        });
                    }
                });
            });
        });
    </script>
@endsection
