@extends('layouts.website')
@section('css')
@endsection
@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-center mt-4 mb-4">
                <h1>LingVPN Simple Pricing</h1>
                <h2>Pay As You Go</h2>
            </div>
            <div class="col-12 text-justify">
                <h4>How am I billed for my products ?</h4>
                <p>
                    All tunneling accounts on your account are billed hourly up to the monthly rate cap.
                    The hourly rate is determined by dividing the monthly rate by 720 hours (30 days).
                    If your tunneling account is online for more than 720 hours in a calendar month, you will only be billed
                    the
                    monthly rate.
                    Accumulated charges are invoiced to your account on the 1st of every month.
                    tunneling account products ( <strong>Shadowsocks</strong>, <strong>Vmess</strong>,
                    <strong>Vless</strong>, <strong>Trojan Go VPN</strong> )
                    will continue to be charged for hourly usage until you delete the account.
                    If you wish to no longer accumulate charges for a tunneling accounts, please use the DELETE button in
                    the customer portal.
                </p>
            </div>
            @foreach ($information as $item)
                <div class="col-12">
                    <div class="alert alert-{{ $item->category }} alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <strong>{{ $item->name }}</strong><br />{{ $item->description }}
                    </div>
                </div>
            @endforeach
            @php
                $item = [
                    [
                        'title' => 'Trojan',
                        'subtitle' => 'Xray Core',
                        'description' => 'Lightweight, Secure and Fast',
                        'created_account' => '2',
                        'price' => '20,000',
                        'price_hour' => '27,78',
                        'detail' => [
                            'Websocket' => 'CDN',
                            'HTTP Upgrade' => 'CDN',
                        ],
                    ],
                    [
                        'title' => 'Vmess',
                        'subtitle' => 'Xray Core',
                        'description' => 'Legacy System, Faster Proto',
                        'created_account' => '3',
                        'price' => '25,000',
                        'price_hour' => '34,73',
                        'detail' => [
                            'Websocket' => 'CDN',
                            'HTTP Upgrade' => 'CDN',
                        ],
                    ],
                    [
                        'title' => 'Vless',
                        'subtitle' => 'Xray Core',
                        'description' => 'Recommended Fast, Secure, and up to date',
                        'created_account' => '4',
                        'price' => '30,000',
                        'price_hour' => '41,67',
                        'detail' => [
                            'XTLS' => 'Protocol /  Reality',
                            'Websocket' => 'CDN',
                            'HTTP Upgrade' => 'CDN',
                        ],
                    ],
                ];
                $item = (object) $item;
            @endphp
            @foreach ($item as $key => $value)
                <div class="col-sm-6 col-lg-4 mb-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <h3 class="profile-username text-center my-0 py-0">{{ $value['title'] }}</h3>
                            <p class="text-muted text-center my-0 py-0">{!! $value['subtitle'] !!}</p>
                            <hr>
                            <div class="text-center">
                                <h5>
                                    <small>Starting from</small><br>
                                    <small>IDR </small><span>{{ $value['price'] }}</span><small>/Month</small><br>
                                    <small>IDR {{ $value['price_hour'] }}/Hours</small>
                                </h5>
                            </div>
                            <hr>
                            <ul class="list-unstyled text-center">
                                @foreach ($value['detail'] as $key2 => $value2)
                                    <li><strong>{{ $key2 }} </strong> {{ $value2 }}</li>
                                @endforeach
                            </ul>
                            <a href="{{ route('register') }}" class="btn btn-dark btn-block"> <i class="fa fa-user"></i>
                                Register Now</a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@endsection
@section('js')
@endsection
